/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util.credential;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.crypto.KeySupport;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class BasicResourceCredentialFactoryBean
implements FactoryBean<BasicCredential> {
    private String secretKeyAlgorithm;
    private char[] privateKeyPassword;
    private Resource publicKeyInfo;
    private Resource privateKeyInfo;
    private Resource secretKeyInfo;
    private String usageType;
    private SecretKeyEncoding secretKeyEncoding = SecretKeyEncoding.BASE64;

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return BasicCredential.class;
    }

    public BasicCredential getObject() throws Exception {
        PrivateKey privateKey = this.getPrivateKey();
        PublicKey publicKey = this.getPublicKey();
        SecretKey secretKey = this.getSecretKey();
        BasicCredential credential = null;
        if (null != publicKey) {
            if (null == privateKey) {
                credential = new BasicCredential(publicKey);
            } else {
                if (!KeySupport.matchKeyPair((PublicKey)publicKey, (PrivateKey)privateKey)) {
                    throw new BeanCreationException("Public and private keys do not match");
                }
                credential = new BasicCredential(publicKey, privateKey);
            }
        } else if (null != secretKey) {
            credential = new BasicCredential(secretKey);
        } else {
            throw new BeanCreationException("Neither public key nor secret key specified");
        }
        if (null != this.getUsageType()) {
            credential.setUsageType(UsageType.valueOf((String)this.getUsageType()));
        }
        return credential;
    }

    protected PublicKey getPublicKey() {
        PublicKey publicKey;
        block9: {
            if (null == this.getPublicKeyInfo()) {
                return null;
            }
            InputStream is = this.getPublicKeyInfo().getInputStream();
            try {
                publicKey = KeyPairUtil.readPublicKey((InputStream)is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FatalBeanException("Could not decode public key", (Throwable)e);
                }
            }
            is.close();
        }
        return publicKey;
    }

    private PrivateKey getPrivateKey() {
        PrivateKey privateKey;
        block9: {
            if (null == this.getPrivateKeyInfo()) {
                return null;
            }
            InputStream is = this.getPrivateKeyInfo().getInputStream();
            try {
                privateKey = KeySupport.decodePrivateKey((InputStream)is, (char[])this.getPrivateKeyPassword());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BeanCreationException("Could not decode private key", (Throwable)e);
                }
            }
            is.close();
        }
        return privateKey;
    }

    private byte[] decodeSecretKey(byte[] data) {
        switch (this.getSecretKeyEncoding()) {
            case BINARY: {
                return data;
            }
            case HEX: {
                return Hex.decode((byte[])data);
            }
        }
        return Base64.decodeBase64((byte[])data);
    }

    private SecretKey getSecretKey() {
        SecretKey secretKey;
        block9: {
            if (null == this.getSecretKeyInfo()) {
                return null;
            }
            InputStream is = this.getSecretKeyInfo().getInputStream();
            try {
                secretKey = KeySupport.decodeSecretKey((byte[])this.decodeSecretKey(ByteStreams.toByteArray((InputStream)is)), (String)this.getSecretKeyAlgorithm());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BeanCreationException("Could not decode secret key", (Throwable)e);
                }
            }
            is.close();
        }
        return secretKey;
    }

    @Generated
    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    @Generated
    public char[] getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Generated
    public Resource getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    @Generated
    public Resource getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    @Generated
    public Resource getSecretKeyInfo() {
        return this.secretKeyInfo;
    }

    @Generated
    public String getUsageType() {
        return this.usageType;
    }

    @Generated
    public SecretKeyEncoding getSecretKeyEncoding() {
        return this.secretKeyEncoding;
    }

    @Generated
    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    @Generated
    public void setPrivateKeyPassword(char[] privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    @Generated
    public void setPublicKeyInfo(Resource publicKeyInfo) {
        this.publicKeyInfo = publicKeyInfo;
    }

    @Generated
    public void setPrivateKeyInfo(Resource privateKeyInfo) {
        this.privateKeyInfo = privateKeyInfo;
    }

    @Generated
    public void setSecretKeyInfo(Resource secretKeyInfo) {
        this.secretKeyInfo = secretKeyInfo;
    }

    @Generated
    public void setUsageType(String usageType) {
        this.usageType = usageType;
    }

    @Generated
    public void setSecretKeyEncoding(SecretKeyEncoding secretKeyEncoding) {
        this.secretKeyEncoding = secretKeyEncoding;
    }

    static enum SecretKeyEncoding {
        BINARY,
        HEX,
        BASE64;

    }
}

