/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator.mongo;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreEntity;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

@Order(value=-2147483648)
public class OidcMongoDbJsonWebKeystoreGeneratorService
implements OidcJsonWebKeystoreGeneratorService {
    private final MongoOperations mongoTemplate;
    private final OidcProperties oidcProperties;

    @Override
    public Resource generate() throws Exception {
        return this.find().orElseGet(Unchecked.supplier(() -> {
            JsonWebKeySet jsonWebKeySet = OidcJsonWebKeystoreGeneratorService.generateJsonWebKeySet(this.oidcProperties);
            return OidcJsonWebKeystoreGeneratorService.toResource(this.store(jsonWebKeySet));
        }));
    }

    @Override
    public JsonWebKeySet store(JsonWebKeySet jsonWebKeySet) throws Exception {
        String issuer = this.oidcProperties.getCore().getIssuer();
        String collectionName = this.oidcProperties.getJwks().getMongo().getCollection();
        OidcJsonWebKeystoreEntity result = (OidcJsonWebKeystoreEntity)this.mongoTemplate.findById((Object)issuer, OidcJsonWebKeystoreEntity.class, collectionName);
        String json = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        Optional.ofNullable(result).ifPresentOrElse(entity -> {
            Update update = Update.update((String)"data", (Object)json);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"issuer").is((Object)entity.getIssuer()));
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
        }, () -> {
            OidcJsonWebKeystoreEntity entity = new OidcJsonWebKeystoreEntity(issuer, json);
            this.mongoTemplate.insert((Object)entity, collectionName);
        });
        return jsonWebKeySet;
    }

    @Override
    public Optional<Resource> find() throws Exception {
        String issuer = this.oidcProperties.getCore().getIssuer();
        OidcJsonWebKeystoreEntity entity = (OidcJsonWebKeystoreEntity)this.mongoTemplate.findById((Object)issuer, OidcJsonWebKeystoreEntity.class, this.oidcProperties.getJwks().getMongo().getCollection());
        return Optional.ofNullable(entity).map(Unchecked.function(jwks -> OidcJsonWebKeystoreGeneratorService.toResource(new JsonWebKeySet(jwks.getData()))));
    }

    @Generated
    public OidcMongoDbJsonWebKeystoreGeneratorService(MongoOperations mongoTemplate, OidcProperties oidcProperties) {
        this.mongoTemplate = mongoTemplate;
        this.oidcProperties = oidcProperties;
    }
}

