/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.impl.EventDeploymentQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.data.EventDeploymentDataManager;

public class EventDeploymentEntityManagerImpl
extends AbstractEngineEntityManager<EventRegistryEngineConfiguration, EventDeploymentEntity, EventDeploymentDataManager>
implements EventDeploymentEntityManager {
    public EventDeploymentEntityManagerImpl(EventRegistryEngineConfiguration eventRegistryConfiguration, EventDeploymentDataManager deploymentDataManager) {
        super((AbstractEngineConfiguration)eventRegistryConfiguration, (DataManager)deploymentDataManager);
    }

    public void insert(EventDeploymentEntity deployment) {
        this.insert(deployment, true);
    }

    public void insert(EventDeploymentEntity deployment, boolean fireEvent) {
        super.insert((Entity)deployment, fireEvent);
        for (EventResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.deleteEventDefinitionsForDeployment(deploymentId);
        this.deleteChannelDefinitionsForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete((EventDeploymentEntity)this.findById(deploymentId));
    }

    protected void deleteEventDefinitionsForDeployment(String deploymentId) {
        this.getEventDefinitionEntityManager().deleteEventDefinitionsByDeploymentId(deploymentId);
    }

    protected void deleteChannelDefinitionsForDeployment(String deploymentId) {
        this.getChannelDefinitionEntityManager().deleteChannelDefinitionsByDeploymentId(deploymentId);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(EventDeploymentQueryImpl deploymentQuery) {
        return ((EventDeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<EventDeployment> findDeploymentsByQueryCriteria(EventDeploymentQueryImpl deploymentQuery) {
        return ((EventDeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((EventDeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<EventDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return ((EventDeploymentDataManager)this.dataManager).findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((EventDeploymentDataManager)this.dataManager).findDeploymentCountByNativeQuery(parameterMap);
    }

    protected EventResourceEntityManager getResourceEntityManager() {
        return ((EventRegistryEngineConfiguration)this.engineConfiguration).getResourceEntityManager();
    }

    protected EventDefinitionEntityManager getEventDefinitionEntityManager() {
        return ((EventRegistryEngineConfiguration)this.engineConfiguration).getEventDefinitionEntityManager();
    }

    protected ChannelDefinitionEntityManager getChannelDefinitionEntityManager() {
        return ((EventRegistryEngineConfiguration)this.engineConfiguration).getChannelDefinitionEntityManager();
    }
}

