/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.AbstractPatchItem;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidEntityException;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.provisioning.api.rules.AccountRule;
import org.apache.syncope.core.provisioning.api.rules.PasswordRule;
import org.apache.syncope.core.provisioning.api.rules.RuleEnforcer;
import org.apache.syncope.core.spring.policy.AccountPolicyException;
import org.apache.syncope.core.spring.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.apache.syncope.core.workflow.java.AbstractWorkflowAdapter;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractUserWorkflowAdapter
extends AbstractWorkflowAdapter
implements UserWorkflowAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(UserWorkflowAdapter.class);
    protected final UserDataBinder dataBinder;
    protected final UserDAO userDAO;
    protected final RealmDAO realmDAO;
    protected final SecurityProperties securityProperties;
    protected final RuleEnforcer ruleEnforcer;

    public AbstractUserWorkflowAdapter(UserDataBinder dataBinder, UserDAO userDAO, RealmDAO realmDAO, GroupDAO groupDAO, EntityFactory entityFactory, SecurityProperties securityProperties, RuleEnforcer ruleEnforcer, ApplicationEventPublisher publisher) {
        super(groupDAO, entityFactory, publisher);
        this.dataBinder = dataBinder;
        this.userDAO = userDAO;
        this.realmDAO = realmDAO;
        this.securityProperties = securityProperties;
        this.ruleEnforcer = ruleEnforcer;
    }

    public String getPrefix() {
        return null;
    }

    protected Pair<Boolean, Boolean> enforcePolicies(User user, boolean disablePwdPolicyCheck, String clearPassword) {
        if (!disablePwdPolicyCheck) {
            LOG.debug("Password Policy enforcement");
            try {
                int maxPPSpecHistory = 0;
                for (PasswordPolicy policy : this.ruleEnforcer.getPasswordPolicies(user.getRealm(), this.userDAO.findAllResources(user))) {
                    if (clearPassword == null && !policy.isAllowNullPassword()) {
                        throw new PasswordPolicyException("Password mandatory");
                    }
                    this.ruleEnforcer.getPasswordRules(policy).forEach(rule -> {
                        rule.enforce(user, clearPassword);
                        user.getLinkedAccounts().stream().filter(account -> account.getPassword() != null).forEach(arg_0 -> ((PasswordRule)rule).enforce(arg_0));
                    });
                    boolean matching = false;
                    if (policy.getHistoryLength() > 0) {
                        List pwdHistory = user.getPasswordHistory();
                        matching = pwdHistory.subList(policy.getHistoryLength() >= pwdHistory.size() ? 0 : pwdHistory.size() - policy.getHistoryLength(), pwdHistory.size()).stream().map(old -> Encryptor.getInstance().verify(clearPassword, user.getCipherAlgorithm(), old)).reduce(matching, (accumulator, item) -> accumulator | item);
                    }
                    if (matching) {
                        throw new PasswordPolicyException("Password value was used in the past: not allowed");
                    }
                    if (policy.getHistoryLength() <= maxPPSpecHistory) continue;
                    maxPPSpecHistory = policy.getHistoryLength();
                }
                if (maxPPSpecHistory > 0 && user.getPassword() != null && !user.getPasswordHistory().contains(user.getPassword())) {
                    user.addToPasswordHistory(user.getPassword());
                }
                if (maxPPSpecHistory < user.getPasswordHistory().size()) {
                    user.removeOldestEntriesFromPasswordHistory(user.getPasswordHistory().size() - maxPPSpecHistory);
                }
            }
            catch (InvalidEntityException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Invalid password for {}", (Object)user, (Object)e);
                throw new InvalidEntityException(User.class, EntityViolationType.InvalidPassword, e.getMessage());
            }
        }
        LOG.debug("Account Policy enforcement");
        boolean suspend = false;
        boolean propagateSuspension = false;
        try {
            if (user.getUsername() == null) {
                throw new AccountPolicyException("Null username");
            }
            if (this.securityProperties.getAdminUser().equals(user.getUsername()) || this.securityProperties.getAnonymousUser().equals(user.getUsername())) {
                throw new AccountPolicyException("Not allowed: " + user.getUsername());
            }
            List accountPolicies = this.ruleEnforcer.getAccountPolicies(user.getRealm(), this.userDAO.findAllResources(user));
            if (accountPolicies.isEmpty()) {
                if (!Entity.ID_PATTERN.matcher(user.getUsername()).matches()) {
                    throw new AccountPolicyException("Character(s) not allowed: " + user.getUsername());
                }
                user.getLinkedAccounts().stream().filter(account -> account.getUsername() != null).forEach(account -> {
                    if (!Entity.ID_PATTERN.matcher(account.getUsername()).matches()) {
                        throw new AccountPolicyException("Character(s) not allowed: " + account.getUsername());
                    }
                });
            } else {
                for (AccountPolicy policy : accountPolicies) {
                    this.ruleEnforcer.getAccountRules(policy).forEach(rule -> {
                        rule.enforce(user);
                        user.getLinkedAccounts().stream().filter(account -> account.getUsername() != null).forEach(arg_0 -> ((AccountRule)rule).enforce(arg_0));
                    });
                    suspend |= user.getFailedLogins() != null && policy.getMaxAuthenticationAttempts() > 0 && user.getFailedLogins() > policy.getMaxAuthenticationAttempts() && user.isSuspended() == false;
                    propagateSuspension |= policy.isPropagateSuspension();
                }
            }
        }
        catch (InvalidEntityException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Invalid username for {}", (Object)user, (Object)e);
            throw new InvalidEntityException(User.class, EntityViolationType.InvalidUsername, e.getMessage());
        }
        return Pair.of((Object)suspend, (Object)propagateSuspension);
    }

    public UserWorkflowResult<Pair<String, Boolean>> create(UserCR userCR, String creator, String context) {
        return this.create(userCR, false, null, creator, context);
    }

    protected abstract UserWorkflowResult<Pair<String, Boolean>> doCreate(UserCR var1, boolean var2, Boolean var3, String var4, String var5);

    public UserWorkflowResult<Pair<String, Boolean>> create(UserCR userCR, boolean disablePwdPolicyCheck, Boolean enabled, String creator, String context) {
        UserWorkflowResult<Pair<String, Boolean>> result = this.doCreate(userCR, disablePwdPolicyCheck, enabled, creator, context);
        User user = (User)this.userDAO.find((String)((Pair)result.getResult()).getKey());
        this.enforcePolicies(user, disablePwdPolicyCheck, disablePwdPolicyCheck ? null : userCR.getPassword());
        user = (User)this.userDAO.save((Any)user);
        user.getMemberships().stream().forEach(m -> this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)((Group)m.getRightEnd()), AuthContextUtils.getDomain())));
        return result;
    }

    protected abstract UserWorkflowResult<String> doActivate(User var1, String var2, String var3, String var4);

    public UserWorkflowResult<String> activate(String key, String token, String updater, String context) {
        return this.doActivate((User)this.userDAO.authFind(key), token, updater, context);
    }

    protected abstract UserWorkflowResult<Pair<UserUR, Boolean>> doUpdate(User var1, UserUR var2, String var3, String var4);

    public UserWorkflowResult<Pair<UserUR, Boolean>> update(UserUR userUR, Boolean enabled, String updater, String context) {
        UserWorkflowResult result;
        User user = (User)this.userDAO.find(userUR.getKey());
        if (userUR.isEmptyButPassword() && !userUR.getPassword().isOnSyncope()) {
            PropagationByResource propByRes = new PropagationByResource();
            this.userDAO.findAllResources(user).stream().filter(resource -> userUR.getPassword().getResources().contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)resource.getKey())));
            PropagationByResource propByLinkedAccount = new PropagationByResource();
            user.getLinkedAccounts().stream().filter(account -> userUR.getPassword().getResources().contains(account.getResource().getKey())).forEach(account -> propByLinkedAccount.add(ResourceOperation.UPDATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
            result = new UserWorkflowResult((Object)Pair.of((Object)userUR, (Object)(user.isSuspended() == false ? 1 : 0)), propByRes, propByLinkedAccount, "update");
        } else {
            result = this.doUpdate((User)this.userDAO.authFind(userUR.getKey()), userUR, updater, context);
        }
        this.enforcePolicies(user, userUR.getPassword() == null && userUR.getLinkedAccounts().stream().allMatch(linkedAccountUR -> linkedAccountUR.getLinkedAccountTO().getPassword() == null), Optional.ofNullable(userUR.getPassword()).map(AbstractPatchItem::getValue).orElse(null));
        user = (User)this.userDAO.save((Any)user);
        if (enabled != null) {
            UserWorkflowResult<String> enableUpdate = null;
            if (user.isSuspended() == null) {
                enableUpdate = this.activate(userUR.getKey(), null, updater, context);
                result.setResult((Object)Pair.of((Object)((UserUR)((Pair)result.getResult()).getLeft()), (Object)true));
            } else if (enabled.booleanValue() && user.isSuspended().booleanValue()) {
                enableUpdate = this.reactivate(userUR.getKey(), updater, context);
                result.setResult((Object)Pair.of((Object)((UserUR)((Pair)result.getResult()).getLeft()), (Object)true));
            } else if (!enabled.booleanValue() && !user.isSuspended().booleanValue()) {
                enableUpdate = this.suspend(userUR.getKey(), updater, context);
                result.setResult((Object)Pair.of((Object)((UserUR)((Pair)result.getResult()).getLeft()), (Object)false));
            }
            Optional.ofNullable(enableUpdate).ifPresent(eu -> {
                Optional.ofNullable(eu.getPropByRes()).ifPresent(eupbr -> {
                    result.getPropByRes().merge(eupbr);
                    result.getPropByRes().purge();
                });
                result.getPerformedTasks().addAll(eu.getPerformedTasks());
            });
        }
        if (!AuthContextUtils.getUsername().equals(user.getUsername())) {
            HashSet authRealms = new HashSet();
            authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault("USER_READ", Set.of()));
            authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault("USER_UPDATE", Set.of()));
            this.userDAO.securityChecks(authRealms, user.getKey(), user.getRealm().getFullPath(), this.userDAO.findAllGroupKeys(user));
        }
        ((UserUR)((Pair)result.getResult()).getLeft()).getMemberships().stream().map(MembershipUR::getGroup).distinct().map(arg_0 -> ((GroupDAO)this.groupDAO).find(arg_0)).filter(Objects::nonNull).forEach(group -> this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)group, AuthContextUtils.getDomain())));
        return result;
    }

    protected abstract UserWorkflowResult<String> doSuspend(User var1, String var2, String var3);

    public UserWorkflowResult<String> suspend(String key, String updater, String context) {
        User user = (User)this.userDAO.authFind(key);
        user.setSuspended(Boolean.TRUE);
        return this.doSuspend(user, updater, context);
    }

    public Pair<UserWorkflowResult<String>, Boolean> internalSuspend(String key, String updater, String context) {
        User user = (User)this.userDAO.authFind(key);
        Pair result = null;
        Pair<Boolean, Boolean> enforce = this.enforcePolicies(user, true, null);
        if (((Boolean)enforce.getKey()).booleanValue()) {
            LOG.debug("User {} {} is over the max failed logins", (Object)user.getKey(), (Object)user.getUsername());
            user.setFailedLogins(Integer.valueOf(user.getFailedLogins() - 1));
            user.setSuspended(Boolean.TRUE);
            result = Pair.of(this.doSuspend(user, updater, context), (Object)((Boolean)enforce.getValue()));
        }
        return result;
    }

    protected abstract UserWorkflowResult<String> doReactivate(User var1, String var2, String var3);

    public UserWorkflowResult<String> reactivate(String key, String updater, String context) {
        User user = (User)this.userDAO.authFind(key);
        user.setFailedLogins(Integer.valueOf(0));
        user.setSuspended(Boolean.FALSE);
        return this.doReactivate(user, updater, context);
    }

    protected abstract void doRequestPasswordReset(User var1, String var2, String var3);

    public void requestPasswordReset(String key, String updater, String context) {
        this.doRequestPasswordReset((User)this.userDAO.authFind(key), updater, context);
    }

    protected abstract UserWorkflowResult<Pair<UserUR, Boolean>> doConfirmPasswordReset(User var1, String var2, String var3, String var4, String var5);

    public UserWorkflowResult<Pair<UserUR, Boolean>> confirmPasswordReset(String key, String token, String password, String updater, String context) {
        User user = (User)this.userDAO.authFind(key);
        this.enforcePolicies(user, false, password);
        user = (User)this.userDAO.save((Any)user);
        return this.doConfirmPasswordReset(user, token, password, updater, context);
    }

    protected abstract void doDelete(User var1, String var2, String var3);

    public void delete(String userKey, String eraser, String context) {
        User user = (User)this.userDAO.authFind(userKey);
        Set<Group> groups = user.getMemberships().stream().map(Relationship::getRightEnd).collect(Collectors.toSet());
        this.doDelete(user, eraser, context);
        groups.forEach(group -> this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)group, AuthContextUtils.getDomain())));
    }
}

