/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.artifact;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.impl.BasicMessageHandlerChain;
import org.opensaml.messaging.handler.impl.CheckExpectedIssuer;
import org.opensaml.messaging.handler.impl.CheckMandatoryAuthentication;
import org.opensaml.messaging.handler.impl.CheckMandatoryIssuer;
import org.opensaml.messaging.handler.impl.SchemaValidateXMLMessage;
import org.opensaml.messaging.pipeline.httpclient.BasicHttpClientMessagePipeline;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipeline;
import org.opensaml.messaging.pipeline.httpclient.HttpClientMessagePipelineFactory;
import org.opensaml.saml.common.binding.impl.CheckMessageVersionHandler;
import org.opensaml.saml.common.binding.impl.PopulateSignatureSigningParametersHandler;
import org.opensaml.saml.common.binding.impl.SAMLMetadataLookupHandler;
import org.opensaml.saml.common.binding.impl.SAMLProtocolAndRoleHandler;
import org.opensaml.saml.common.binding.impl.SAMLSOAPDecoderBodyHandler;
import org.opensaml.saml.common.binding.security.impl.CheckAndRecordServerTLSEntityAuthenticationtHandler;
import org.opensaml.saml.common.binding.security.impl.InResponseToSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.MessageLifetimeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.MessageReplaySecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLProtocolMessageXMLSignatureSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.binding.decoding.impl.HttpClientResponseSOAP11Decoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HttpClientRequestSOAP11Encoder;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.impl.BasicSignatureValidationParametersResolver;
import org.opensaml.xmlsec.messaging.impl.PopulateSignatureValidationParametersHandler;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.sso.artifact.DefaultSignatureSigningParametersResolver;
import org.pac4j.saml.sso.artifact.IssuerFunction;
import org.xml.sax.SAXException;

public class DefaultSOAPPipelineFactory
implements HttpClientMessagePipelineFactory {
    protected final SAML2Configuration configuration;
    protected final SAML2MetadataResolver idpMetadataResolver;
    protected final SAML2MetadataResolver spMetadataResolver;
    protected final SignatureSigningParametersProvider signingParametersProvider;
    protected final SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    protected final ReplayCacheProvider replayCache;

    public DefaultSOAPPipelineFactory(SAML2Configuration configuration, SAML2MetadataResolver idpMetadataResolver, SAML2MetadataResolver spMetadataResolver, SignatureSigningParametersProvider signingParametersProvider, SAML2SignatureTrustEngineProvider signatureTrustEngineProvider, ReplayCacheProvider replayCache) {
        this.configuration = configuration;
        this.idpMetadataResolver = idpMetadataResolver;
        this.spMetadataResolver = spMetadataResolver;
        this.signingParametersProvider = signingParametersProvider;
        this.signatureTrustEngineProvider = signatureTrustEngineProvider;
        this.replayCache = replayCache;
    }

    protected List<MessageHandler> getInboundHandlers() throws ComponentInitializationException {
        ArrayList<MessageHandler> handlers = new ArrayList<MessageHandler>();
        handlers.add(this.buildSAMLProtocolAndRoleHandler(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        handlers.add(this.buildSAMLMetadataLookupHandler(this.idpMetadataResolver));
        handlers.add(this.buildSchemaValidateXMLMessage());
        handlers.add(this.buildCheckMessageVersionHandler());
        handlers.add(this.buildMessageLifetimeSecurityHandler());
        handlers.add(this.buildInResponseToSecurityHandler());
        handlers.add(this.buildMessageReplaySecurityHandler());
        handlers.add(this.buildCheckMandatoryIssuer());
        handlers.add(this.buildCheckExpectedIssuer());
        handlers.add(this.buildPopulateSignatureSigningParametersHandler());
        handlers.add(this.buildPopulateSignatureValidationParametersHandler());
        handlers.add(this.buildSAMLProtocolMessageXMLSignatureSecurityHandler());
        handlers.add(this.buildCheckAndRecordServerTLSEntityAuthenticationtHandler());
        handlers.add(this.buildCheckMandatoryAuthentication());
        handlers.add(this.buildSAMLSOAPDecoderBodyHandler());
        return handlers;
    }

    protected List<MessageHandler> getOutboundPayloadHandlers() throws ComponentInitializationException {
        ArrayList<MessageHandler> handlers = new ArrayList<MessageHandler>();
        handlers.add(this.buildSAMLProtocolAndRoleHandler(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        handlers.add(this.buildSAMLMetadataLookupHandler(this.spMetadataResolver));
        handlers.add(this.buildPopulateSignatureSigningParametersHandler());
        handlers.add(this.buildSAMLOutboundProtocolMessageSigningHandler());
        return handlers;
    }

    protected List<MessageHandler> getOutboundTransportHandlers() throws ComponentInitializationException {
        return new ArrayList<MessageHandler>();
    }

    protected MessageHandler buildSAMLProtocolAndRoleHandler(QName roleName) throws ComponentInitializationException {
        SAMLProtocolAndRoleHandler protocolAndRoleHandler = new SAMLProtocolAndRoleHandler();
        protocolAndRoleHandler.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        protocolAndRoleHandler.setRole(roleName);
        protocolAndRoleHandler.initialize();
        return protocolAndRoleHandler;
    }

    protected MessageHandler buildSAMLMetadataLookupHandler(SAML2MetadataResolver metadataResolver) throws ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver(metadataResolver.resolve());
        roleResolver.initialize();
        SAMLMetadataLookupHandler metadataLookupHandler = new SAMLMetadataLookupHandler();
        metadataLookupHandler.setRoleDescriptorResolver((RoleDescriptorResolver)roleResolver);
        metadataLookupHandler.initialize();
        return metadataLookupHandler;
    }

    protected MessageHandler buildSchemaValidateXMLMessage() throws ComponentInitializationException {
        try {
            SchemaValidateXMLMessage validateXMLHandler = new SchemaValidateXMLMessage(new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11).getSAMLSchema());
            validateXMLHandler.initialize();
            return validateXMLHandler;
        }
        catch (SAXException e) {
            throw new ComponentInitializationException((Exception)e);
        }
    }

    protected MessageHandler buildCheckMessageVersionHandler() throws ComponentInitializationException {
        CheckMessageVersionHandler messageVersionHandler = new CheckMessageVersionHandler();
        messageVersionHandler.initialize();
        return messageVersionHandler;
    }

    protected MessageHandler buildMessageLifetimeSecurityHandler() throws ComponentInitializationException {
        MessageLifetimeSecurityHandler lifetimeHandler = new MessageLifetimeSecurityHandler();
        lifetimeHandler.setClockSkew(Duration.ofMillis(this.configuration.getAcceptedSkew() * 1000L));
        lifetimeHandler.initialize();
        return lifetimeHandler;
    }

    protected MessageHandler buildInResponseToSecurityHandler() throws ComponentInitializationException {
        InResponseToSecurityHandler inResponseToHandler = new InResponseToSecurityHandler();
        inResponseToHandler.initialize();
        return inResponseToHandler;
    }

    protected MessageHandler buildMessageReplaySecurityHandler() throws ComponentInitializationException {
        MessageReplaySecurityHandler messageReplayHandler = new MessageReplaySecurityHandler();
        messageReplayHandler.setExpires(Duration.ofMillis(this.configuration.getAcceptedSkew() * 1000L));
        messageReplayHandler.setReplayCache(this.replayCache.get());
        messageReplayHandler.initialize();
        return messageReplayHandler;
    }

    protected MessageHandler buildCheckMandatoryIssuer() throws ComponentInitializationException {
        CheckMandatoryIssuer mandatoryIssuer = new CheckMandatoryIssuer();
        mandatoryIssuer.setIssuerLookupStrategy((Function)((Object)new IssuerFunction()));
        mandatoryIssuer.initialize();
        return mandatoryIssuer;
    }

    protected MessageHandler buildCheckExpectedIssuer() throws ComponentInitializationException {
        CheckExpectedIssuer expectedIssuer = new CheckExpectedIssuer();
        expectedIssuer.setIssuerLookupStrategy((Function)((Object)new IssuerFunction()));
        expectedIssuer.setExpectedIssuerLookupStrategy(messageContext -> this.idpMetadataResolver.getEntityId());
        expectedIssuer.initialize();
        return expectedIssuer;
    }

    protected MessageHandler buildPopulateSignatureSigningParametersHandler() throws ComponentInitializationException {
        PopulateSignatureSigningParametersHandler signatureSigningParameters = new PopulateSignatureSigningParametersHandler();
        signatureSigningParameters.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new DefaultSignatureSigningParametersResolver(this.signingParametersProvider));
        signatureSigningParameters.initialize();
        return signatureSigningParameters;
    }

    protected MessageHandler buildPopulateSignatureValidationParametersHandler() throws ComponentInitializationException {
        PopulateSignatureValidationParametersHandler signatureValidationParameters = new PopulateSignatureValidationParametersHandler();
        signatureValidationParameters.setSignatureValidationParametersResolver((SignatureValidationParametersResolver)new BasicSignatureValidationParametersResolver(){

            protected SignatureTrustEngine resolveSignatureTrustEngine(CriteriaSet criteria) {
                return DefaultSOAPPipelineFactory.this.signatureTrustEngineProvider.build();
            }
        });
        signatureValidationParameters.initialize();
        return signatureValidationParameters;
    }

    protected MessageHandler buildSAMLProtocolMessageXMLSignatureSecurityHandler() throws ComponentInitializationException {
        SAMLProtocolMessageXMLSignatureSecurityHandler messageXMLSignatureHandler = new SAMLProtocolMessageXMLSignatureSecurityHandler();
        messageXMLSignatureHandler.initialize();
        return messageXMLSignatureHandler;
    }

    protected MessageHandler buildCheckAndRecordServerTLSEntityAuthenticationtHandler() throws ComponentInitializationException {
        CheckAndRecordServerTLSEntityAuthenticationtHandler tlsHandler = new CheckAndRecordServerTLSEntityAuthenticationtHandler();
        tlsHandler.initialize();
        return tlsHandler;
    }

    protected MessageHandler buildCheckMandatoryAuthentication() {
        CheckMandatoryAuthentication mandatoryAuthentication = new CheckMandatoryAuthentication();
        mandatoryAuthentication.setAuthenticationLookupStrategy(context -> ((SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class)).isAuthenticated());
        return mandatoryAuthentication;
    }

    protected MessageHandler buildSAMLSOAPDecoderBodyHandler() throws ComponentInitializationException {
        SAMLSOAPDecoderBodyHandler soapDecoderBody = new SAMLSOAPDecoderBodyHandler();
        soapDecoderBody.initialize();
        return soapDecoderBody;
    }

    protected MessageHandler buildSAMLOutboundProtocolMessageSigningHandler() throws ComponentInitializationException {
        SAMLOutboundProtocolMessageSigningHandler messageSigner = new SAMLOutboundProtocolMessageSigningHandler();
        messageSigner.initialize();
        return messageSigner;
    }

    protected BasicMessageHandlerChain toHandlerChain(List<MessageHandler> handlers) {
        BasicMessageHandlerChain ret = new BasicMessageHandlerChain();
        ret.setHandlers(handlers);
        return ret;
    }

    @Nonnull
    public HttpClientMessagePipeline newInstance() {
        BasicHttpClientMessagePipeline ret = new BasicHttpClientMessagePipeline((MessageEncoder)new HttpClientRequestSOAP11Encoder(), (MessageDecoder)new HttpClientResponseSOAP11Decoder());
        try {
            ret.setInboundHandler((MessageHandler)this.toHandlerChain(this.getInboundHandlers()));
            ret.setOutboundPayloadHandler((MessageHandler)this.toHandlerChain(this.getOutboundPayloadHandlers()));
            ret.setOutboundTransportHandler((MessageHandler)this.toHandlerChain(this.getOutboundTransportHandlers()));
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Nonnull
    public HttpClientMessagePipeline newInstance(@Nullable String pipelineName) {
        return this.newInstance();
    }
}

