/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.thymeleaf.templateparser.text.CommentProcessorTextHandler;
import org.thymeleaf.templateparser.text.EventProcessorTextHandler;
import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.ParsingLocatorUtil;
import org.thymeleaf.templateparser.text.TextParseException;
import org.thymeleaf.templateparser.text.TextParseStatus;
import org.thymeleaf.templateparser.text.TextParsingCommentUtil;
import org.thymeleaf.templateparser.text.TextParsingElementUtil;
import org.thymeleaf.templateparser.text.TextParsingLiteralUtil;
import org.thymeleaf.templateparser.text.TextParsingUtil;

final class TextParser {
    private final BufferPool pool;
    private final boolean processCommentsAndLiterals;
    private final boolean standardDialectPresent;

    TextParser(int poolSize, int bufferSize, boolean processCommentsAndLiterals, boolean standardDialectPresent) {
        this.pool = new BufferPool(poolSize, bufferSize);
        this.processCommentsAndLiterals = processCommentsAndLiterals;
        this.standardDialectPresent = standardDialectPresent;
    }

    public void parse(String document, ITextHandler handler) throws TextParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.parse(new StringReader(document), handler);
    }

    public void parse(Reader reader, ITextHandler handler) throws TextParseException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        ITextHandler handlerChain = handler;
        handlerChain = new EventProcessorTextHandler(handlerChain);
        if (this.processCommentsAndLiterals) {
            handlerChain = new CommentProcessorTextHandler(this.standardDialectPresent, handlerChain);
        }
        this.parseDocument(reader, this.pool.poolBufferSize, handlerChain);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseDocument(Reader reader, int suggestedBufferSize, ITextHandler handler) throws TextParseException {
        long parsingStartTimeNanos = System.nanoTime();
        char[] buffer = null;
        try {
            TextParseStatus status2333332 = new TextParseStatus();
            handler.handleDocumentStart(parsingStartTimeNanos, 1, 1);
            int bufferSize = suggestedBufferSize;
            buffer = this.pool.allocateBuffer(bufferSize);
            int bufferContentSize = reader.read(buffer);
            boolean cont = bufferContentSize != -1;
            status2333332.offset = -1;
            status2333332.line = 1;
            status2333332.col = 1;
            status2333332.inStructure = false;
            status2333332.inCommentLine = false;
            status2333332.literalMarker = '\u0000';
            while (cont) {
                this.parseBuffer(buffer, 0, bufferContentSize, handler, status2333332);
                int readOffset = 0;
                int readLen = bufferSize;
                if (status2333332.offset == 0) {
                    if (bufferContentSize == bufferSize) {
                        char[] newBuffer = null;
                        try {
                            newBuffer = this.pool.allocateBuffer(bufferSize *= 2);
                            System.arraycopy(buffer, 0, newBuffer, 0, bufferContentSize);
                            this.pool.releaseBuffer(buffer);
                            buffer = newBuffer;
                        }
                        catch (Exception ignored) {
                            this.pool.releaseBuffer(newBuffer);
                        }
                    }
                    readOffset = bufferContentSize;
                    readLen = bufferSize - readOffset;
                } else if (status2333332.offset < bufferContentSize) {
                    System.arraycopy(buffer, status2333332.offset, buffer, 0, bufferContentSize - status2333332.offset);
                    readOffset = bufferContentSize - status2333332.offset;
                    readLen = bufferSize - readOffset;
                    status2333332.offset = 0;
                    bufferContentSize = readOffset;
                }
                int read = reader.read(buffer, readOffset, readLen);
                if (read != -1) {
                    bufferContentSize = readOffset + read;
                    continue;
                }
                cont = false;
            }
            int lastLine = status2333332.line;
            int lastCol = status2333332.col;
            int lastStart = status2333332.offset;
            int lastLen = bufferContentSize - lastStart;
            if (lastLen > 0) {
                if (status2333332.inStructure && !status2333332.inCommentLine) {
                    throw new TextParseException("Incomplete structure: \"" + new String(buffer, lastStart, lastLen) + "\"", status2333332.line, status2333332.col);
                }
                handler.handleText(buffer, lastStart, lastLen, status2333332.line, status2333332.col);
                for (int i = lastStart; i < lastStart + lastLen; ++i) {
                    char c = buffer[i];
                    if (c == '\n') {
                        ++lastLine;
                        lastCol = 1;
                        continue;
                    }
                    ++lastCol;
                }
            }
            long parsingEndTimeNanos = System.nanoTime();
            handler.handleDocumentEnd(parsingEndTimeNanos, parsingEndTimeNanos - parsingStartTimeNanos, lastLine, lastCol);
        }
        catch (TextParseException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new TextParseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.pool.releaseBuffer(buffer);
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.pool.releaseBuffer(buffer);
        try {
            reader.close();
            return;
        }
        catch (Throwable status2333332) {
            return;
        }
    }

    private void parseBuffer(char[] buffer, int offset, int len, ITextHandler handler, TextParseStatus status) throws TextParseException {
        int i;
        int[] locator = new int[]{status.line, status.col};
        int currentLine = locator[0];
        int currentCol = locator[1];
        int maxi = offset + len;
        int current = i = offset;
        boolean inOpenElement = false;
        boolean inCloseElement = false;
        boolean inCommentBlock = false;
        boolean inCommentLine = false;
        boolean inLiteral = false;
        int pos = i;
        int tagStart = i;
        int tagEnd = i;
        while (i < maxi) {
            boolean inStructure;
            boolean bl = inStructure = inOpenElement || inCloseElement || inCommentBlock || inCommentLine || inLiteral;
            if (!inStructure) {
                pos = TextParsingUtil.findNextStructureStartOrLiteralMarker(buffer, i, maxi, locator, this.processCommentsAndLiterals);
                if (pos == -1) {
                    status.offset = current;
                    status.line = currentLine;
                    status.col = currentCol;
                    status.inStructure = false;
                    status.inCommentLine = false;
                    status.literalMarker = '\u0000';
                    return;
                }
                char c = buffer[pos];
                inOpenElement = TextParsingElementUtil.isOpenElementStart(buffer, pos, maxi);
                if (!(inOpenElement || (inCloseElement = TextParsingElementUtil.isCloseElementStart(buffer, pos, maxi)) || !this.processCommentsAndLiterals || (inCommentBlock = TextParsingCommentUtil.isCommentBlockStart(buffer, pos, maxi)) || (inCommentLine = TextParsingCommentUtil.isCommentLineStart(buffer, pos, maxi)))) {
                    inLiteral = c == '\'' || c == '\"' || c == '`' || TextParsingLiteralUtil.isRegexLiteralStart(buffer, pos, maxi);
                    status.literalMarker = inLiteral ? c : (char)'\u0000';
                }
                boolean bl2 = inStructure = inOpenElement || inCloseElement || inCommentBlock || inCommentLine || inLiteral;
                if (inStructure && !inLiteral) {
                    tagStart = pos;
                }
                while (!inStructure) {
                    ParsingLocatorUtil.countChar(locator, c);
                    pos = TextParsingUtil.findNextStructureStartOrLiteralMarker(buffer, pos + 1, maxi, locator, this.processCommentsAndLiterals);
                    if (pos == -1) {
                        status.offset = current;
                        status.line = currentLine;
                        status.col = currentCol;
                        status.inStructure = false;
                        status.inCommentLine = false;
                        status.literalMarker = '\u0000';
                        return;
                    }
                    c = buffer[pos];
                    inOpenElement = TextParsingElementUtil.isOpenElementStart(buffer, pos, maxi);
                    if (!(inOpenElement || (inCloseElement = TextParsingElementUtil.isCloseElementStart(buffer, pos, maxi)) || !this.processCommentsAndLiterals || (inCommentBlock = TextParsingCommentUtil.isCommentBlockStart(buffer, pos, maxi)) || (inCommentLine = TextParsingCommentUtil.isCommentLineStart(buffer, pos, maxi)))) {
                        inLiteral = c == '\'' || c == '\"' || c == '`' || TextParsingLiteralUtil.isRegexLiteralStart(buffer, pos, maxi);
                        status.literalMarker = inLiteral ? c : (char)'\u0000';
                    }
                    if (!(inStructure = inOpenElement || inCloseElement || inCommentBlock || inCommentLine || inLiteral) || inLiteral) continue;
                    tagStart = pos;
                }
                if (tagStart > current) {
                    handler.handleText(buffer, current, tagStart - current, currentLine, currentCol);
                }
                if (tagStart == pos) {
                    current = tagStart;
                    currentLine = locator[0];
                    currentCol = locator[1];
                }
                i = pos;
                continue;
            }
            int n = inLiteral ? TextParsingUtil.findNextLiteralEnd(buffer, i, maxi, locator, status.literalMarker) : (inCommentBlock ? TextParsingUtil.findNextCommentBlockEnd(buffer, i, maxi, locator) : (pos = inCommentLine ? TextParsingUtil.findNextCommentLineEnd(buffer, i, maxi, locator) : TextParsingUtil.findNextStructureEndAvoidQuotes(buffer, i, maxi, locator)));
            if (pos < 0) {
                status.offset = current;
                status.line = currentLine;
                status.col = currentCol;
                status.inStructure = true;
                status.inCommentLine = inCommentLine;
                status.literalMarker = '\u0000';
                return;
            }
            if (inOpenElement) {
                tagEnd = pos;
                if (buffer[tagEnd - 1] == '/') {
                    TextParsingElementUtil.parseStandaloneElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                } else {
                    TextParsingElementUtil.parseOpenElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                }
                inOpenElement = false;
            } else if (inCloseElement) {
                tagEnd = pos;
                TextParsingElementUtil.parseCloseElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                inCloseElement = false;
            } else if (inCommentBlock) {
                tagEnd = pos;
                TextParsingCommentUtil.parseComment(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler);
                inCommentBlock = false;
            } else if (inCommentLine) {
                tagEnd = pos;
                handler.handleText(buffer, current, tagEnd - current + 1, currentLine, currentCol);
                inCommentLine = false;
            } else if (inLiteral) {
                inLiteral = false;
                status.literalMarker = '\u0000';
            } else {
                throw new IllegalStateException("Illegal parsing state: structure is not of a recognized type");
            }
            ParsingLocatorUtil.countChar(locator, buffer[pos]);
            if (tagEnd == pos) {
                current = tagEnd + 1;
                currentLine = locator[0];
                currentCol = locator[1];
            }
            i = pos + 1;
        }
        status.offset = current;
        status.line = currentLine;
        status.col = currentCol;
        status.inStructure = false;
        status.inCommentLine = false;
        status.literalMarker = '\u0000';
    }

    private static final class BufferPool {
        private final char[][] pool;
        private final boolean[] allocated;
        private final int poolBufferSize;

        private BufferPool(int poolSize, int poolBufferSize) {
            this.pool = new char[poolSize][];
            this.allocated = new boolean[poolSize];
            this.poolBufferSize = poolBufferSize;
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new char[this.poolBufferSize];
            }
            Arrays.fill(this.allocated, false);
        }

        private synchronized char[] allocateBuffer(int bufferSize) {
            if (bufferSize != this.poolBufferSize) {
                return new char[bufferSize];
            }
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.allocated[i]) continue;
                this.allocated[i] = true;
                return this.pool[i];
            }
            return new char[bufferSize];
        }

        private synchronized void releaseBuffer(char[] buffer) {
            if (buffer == null) {
                return;
            }
            if (buffer.length != this.poolBufferSize) {
                return;
            }
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] != buffer) continue;
                this.allocated[i] = false;
                return;
            }
        }
    }
}

