/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.net.URI;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RedirectUnauthorizedServiceUrlAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectUnauthorizedServiceUrlAction.class);
    private final ServicesManager servicesManager;
    private final ApplicationContext applicationContext;

    public Event doExecute(RequestContext context) {
        URI redirectUrl = this.determineUnauthorizedServiceRedirectUrl(context);
        String url = redirectUrl.toString();
        if (ScriptingUtils.isExternalGroovyScript((String)url)) {
            Resource scriptResource = this.applicationContext.getResource(url);
            RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)context);
            Object[] args = new Object[]{registeredService, context, this.applicationContext, LOGGER};
            redirectUrl = (URI)ScriptingUtils.executeGroovyScript((Resource)scriptResource, (Object[])args, URI.class, (boolean)true);
        }
        LOGGER.debug("Redirecting to unauthorized redirect URL [{}]", (Object)redirectUrl);
        WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)redirectUrl);
        return null;
    }

    protected URI determineUnauthorizedServiceRedirectUrl(RequestContext context) {
        URI redirectUrl = WebUtils.getUnauthorizedRedirectUrlFromFlowScope((RequestContext)context);
        Event currentEvent = context.getCurrentEvent();
        AttributeMap eventAttributes = currentEvent.getAttributes();
        LOGGER.debug("Finalizing the unauthorized redirect URL [{}] when processing event [{}] with attributes [{}]", new Object[]{redirectUrl, currentEvent.getId(), eventAttributes});
        return redirectUrl;
    }

    @Generated
    public RedirectUnauthorizedServiceUrlAction(ServicesManager servicesManager, ApplicationContext applicationContext) {
        this.servicesManager = servicesManager;
        this.applicationContext = applicationContext;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

