/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ADictBasedColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupLinearFunctional;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;

public interface ColGroupIO {
    public static final Log LOG = LogFactory.getLog((String)ColGroupIO.class.getName());

    public static List<AColGroup> readGroups(DataInput in, int nRows) throws IOException {
        int nColGroups = in.readInt();
        ArrayList<AColGroup> _colGroups = new ArrayList<AColGroup>(nColGroups);
        for (int i = 0; i < nColGroups; ++i) {
            _colGroups.add(ColGroupIO.readColGroup(in, nRows));
        }
        return _colGroups;
    }

    public static void writeGroups(DataOutput out, Collection<AColGroup> colGroups) throws IOException {
        out.writeInt(colGroups.size());
        for (AColGroup grp : colGroups) {
            grp.write(out);
        }
    }

    public static long getExactSizeOnDisk(List<AColGroup> colGroups) {
        long ret = 4L;
        HashSet<IDictionary> dicts = new HashSet<IDictionary>();
        for (AColGroup grp : colGroups) {
            if (grp instanceof ADictBasedColGroup) {
                IDictionary dict = ((ADictBasedColGroup)grp).getDictionary();
                if (dicts.contains(dict)) {
                    ret -= dict.getExactSizeOnDisk();
                }
                dicts.add(dict);
            }
            ret += grp.getExactSizeOnDisk();
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)(" duplicate dicts on exact Size on Disk : " + (colGroups.size() - dicts.size())));
        }
        return ret;
    }

    public static AColGroup readColGroup(DataInput in, int nRows) throws IOException {
        AColGroup.ColGroupType ctype = AColGroup.ColGroupType.values()[in.readByte()];
        switch (ctype) {
            case DDC: {
                return ColGroupDDC.read(in);
            }
            case DDCFOR: {
                return ColGroupDDCFOR.read(in);
            }
            case OLE: {
                return ColGroupOLE.read(in, nRows);
            }
            case RLE: {
                return ColGroupRLE.read(in, nRows);
            }
            case CONST: {
                return ColGroupConst.read(in);
            }
            case EMPTY: {
                return ColGroupEmpty.read(in);
            }
            case UNCOMPRESSED: {
                return ColGroupUncompressed.read(in);
            }
            case SDC: {
                return ColGroupSDC.read(in, nRows);
            }
            case SDCSingle: {
                return ColGroupSDCSingle.read(in, nRows);
            }
            case SDCSingleZeros: {
                return ColGroupSDCSingleZeros.read(in, nRows);
            }
            case SDCZeros: {
                return ColGroupSDCZeros.read(in, nRows);
            }
            case SDCFOR: {
                return ColGroupSDCFOR.read(in, nRows);
            }
            case LinearFunctional: {
                return ColGroupLinearFunctional.read(in, nRows);
            }
        }
        throw new DMLRuntimeException("Unsupported ColGroup Type used: " + ctype);
    }

    public static double[] readDoubleArray(int length, DataInput in) throws IOException {
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in.readDouble();
        }
        return ret;
    }
}

