/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ACachingMBDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.MemoryEstimates;

public class QDictionary
extends ACachingMBDictionary {
    private static final long serialVersionUID = 2100501253343438897L;
    protected double _scale;
    protected byte[] _values;
    protected int _nCol;

    protected QDictionary(byte[] values, double scale, int nCol) {
        this._values = values;
        this._scale = scale;
        this._nCol = nCol;
    }

    public static QDictionary create(byte[] values, double scale, int nCol, boolean check) {
        if (scale == 0.0) {
            return null;
        }
        if (check) {
            boolean containsOnlyZero = true;
            for (int i = 0; i < values.length && containsOnlyZero; ++i) {
                if (values[i] == 0) continue;
                containsOnlyZero = false;
            }
            if (containsOnlyZero) {
                return null;
            }
        }
        return new QDictionary(values, scale, nCol);
    }

    @Override
    public double[] getValues() {
        double[] res = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            res[i] = this.getValue(i);
        }
        return res;
    }

    @Override
    public double getValue(int i) {
        return (double)this._values[i] * this._scale;
    }

    @Override
    public final double getValue(int r, int c, int nCol) {
        return (double)this._values[r * nCol + c] * this._scale;
    }

    @Override
    public long getInMemorySize() {
        return QDictionary.getInMemorySize(this.size());
    }

    public static long getInMemorySize(int valuesCount) {
        return 16L + (long)MemoryEstimates.byteArrayCost(valuesCount) + 8L;
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        int len = this.size();
        double ret = init;
        for (int i = 0; i < len; ++i) {
            ret = fn.execute(ret, this.getValue(i));
        }
        return ret;
    }

    private int size() {
        return this._values.length;
    }

    @Override
    public QDictionary clone() {
        return new QDictionary((byte[])this._values.clone(), this._scale, this._nCol);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.INT8_DICT.ordinal());
        out.writeDouble(this._scale);
        out.writeInt(this._values.length);
        for (int i = 0; i < this._values.length; ++i) {
            out.writeByte(this._values[i]);
        }
        out.writeInt(this._nCol);
    }

    public static QDictionary read(DataInput in) throws IOException {
        double scale = in.readDouble();
        int numVals = in.readInt();
        byte[] values = new byte[numVals];
        for (int i = 0; i < numVals; ++i) {
            values[i] = in.readByte();
        }
        int nCol = in.readInt();
        return new QDictionary(values, scale, nCol);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13 + this.size() + 4;
    }

    @Override
    public int getNumberOfValues(int nCol) {
        return this._values.length / nCol;
    }

    @Override
    public int getNumberOfColumns(int nCol) {
        return this._values.length / nCol;
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        if (nrColumns == 1) {
            return this.getValues();
        }
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRow(k, nrColumns);
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRowSq(k, nrColumns);
        }
        return ret;
    }

    private double sumRow(int k, int nrColumns) {
        int valOff = k * nrColumns;
        int res = 0;
        for (int i = 0; i < nrColumns; ++i) {
            res += this._values[valOff + i];
        }
        return (double)res * this._scale;
    }

    private double sumRowSq(int k, int nrColumns) {
        int valOff = k * nrColumns;
        double res = 0.0;
        for (int i = 0; i < nrColumns; ++i) {
            res += (double)(this._values[valOff + i] * this._values[valOff + i]) * this._scale * this._scale;
        }
        return res;
    }

    @Override
    public String getString(int colIndexes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this._values[i]);
            sb.append(i % colIndexes == colIndexes - 1 ? "\n" : " ");
        }
        return sb.toString();
    }

    @Override
    public IDictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        int numberTuples = this.getNumberOfValues(previousNumberOfColumns);
        int tupleLengthAfter = idxEnd - idxStart;
        byte[] newDictValues = new byte[tupleLengthAfter * numberTuples];
        int orgOffset = idxStart;
        int targetOffset = 0;
        for (int v = 0; v < numberTuples; ++v) {
            int c = 0;
            while (c < tupleLengthAfter) {
                newDictValues[targetOffset] = this._values[orgOffset];
                ++c;
                ++orgOffset;
                ++targetOffset;
            }
            orgOffset += previousNumberOfColumns - idxEnd + idxStart;
        }
        return new QDictionary(newDictValues, this._scale, this._nCol);
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        long nnz = 0L;
        int nRow = this._values.length / nCol;
        for (int i = 0; i < nRow; ++i) {
            int off;
            long rowCount = 0L;
            for (int j = off = i * nCol; j < off + nCol; ++j) {
                if (this._values[j] == 0) continue;
                ++rowCount;
            }
            nnz += rowCount * (long)counts[i];
        }
        return nnz;
    }

    @Override
    public int[] countNNZZeroColumns(int[] counts) {
        int nRow = counts.length;
        int nCol = this._values.length / nRow;
        int[] ret = new int[nCol];
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                int off = i * nCol + j;
                if (this._values[off] == 0) continue;
                int n = j;
                ret[n] = ret[n] + counts[i];
            }
        }
        return ret;
    }

    @Override
    public IDictionary.DictType getDictType() {
        return IDictionary.DictType.UInt8;
    }

    @Override
    public double getSparsity() {
        int nnz = 0;
        for (int i = 0; i < this._values.length; ++i) {
            nnz += this._values[i] == 0 ? 0 : 1;
        }
        return (double)nnz / (double)this._values.length;
    }

    @Override
    public boolean equals(IDictionary o) {
        return this.getMBDict().equals(o);
    }

    @Override
    public MatrixBlockDictionary getMBDict() {
        return this.getMBDict(this._nCol);
    }

    @Override
    public MatrixBlockDictionary createMBDict(int nCol) {
        MatrixBlock mb = new MatrixBlock(this._values.length / nCol, nCol, false);
        mb.allocateDenseBlock();
        double[] dbv = mb.getDenseBlockValues();
        for (int i = 0; i < this._values.length; ++i) {
            dbv[i] = (double)this._values[i] * this._scale;
        }
        mb.recomputeNonZeros();
        return new MatrixBlockDictionary(mb);
    }
}

