/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.lang.reflect.Method;
import javax.annotation.PreDestroy;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.internal.jpa.NoopAnnotatedType;
import org.apache.tapestry5.internal.jpa.NoopBeanManager;
import org.apache.tapestry5.internal.jpa.NoopCreationalContext;
import org.apache.tapestry5.internal.jpa.NoopInjectionTarget;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapestryCDIBeanManagerForJPAEntityListeners
extends NoopBeanManager {
    private static final Logger logger = LoggerFactory.getLogger(TapestryCDIBeanManagerForJPAEntityListeners.class);
    @Inject
    private ObjectLocator objectLocator;

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(final Class<T> type) {
        return new NoopAnnotatedType<T>(){

            @Override
            public Class<T> getJavaClass() {
                return type;
            }
        };
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(final AnnotatedType<T> type) {
        return new NoopInjectionTarget<T>(){

            @Override
            public T produce(CreationalContext<T> ctx) {
                return TapestryCDIBeanManagerForJPAEntityListeners.this.objectLocator.autobuild(type.getJavaClass());
            }

            @Override
            public void preDestroy(T instance) {
                try {
                    for (Method method : type.getJavaClass().getMethods()) {
                        if (method.getAnnotation(PreDestroy.class) == null) continue;
                        method.invoke(instance, new Object[0]);
                    }
                }
                catch (Exception e) {
                    logger.error("Error invoking @PreDestroy callback on instance of class " + type.getJavaClass(), (Throwable)e);
                }
            }
        };
    }

    @Override
    public <T> CreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return new NoopCreationalContext();
    }
}

