export default class Bytecode {
    sourceInstructions: any[];
    stepInstructions: any[];
    /**
     * Creates a new instance of Bytecode
     * @param {Bytecode} [toClone]
     */
    constructor(toClone?: Bytecode);
    /**
     * Adds a new source instructions
     * @param {String} name
     * @param {Array} values
     * @returns {Bytecode}
     */
    addSource(name: string, values: any[]): Bytecode;
    /**
     * Adds a new step instructions
     * @param {String} name
     * @param {Array} values
     * @returns {Bytecode}
     */
    addStep(name: string, values?: any[]): Bytecode;
    private static _generateInstruction;
    /**
     * Returns the JSON representation of the source and step instructions
     * @returns {String}
     */
    toString(): string;
    /**
     * Adds a new source instructions
     * @param {String} name
     * @param {Array} values
     * @returns {Bytecode}
     */
    static _createGraphOp(name: string, values: any[]): Bytecode;
    /**
     * Gets the <code>Bytecode</code> that is meant to be sent as "graph operations" to the server.
     * @returns {{rollback: Bytecode, commit: Bytecode}}
     */
    static get GraphOp(): {
        rollback: Bytecode;
        commit: Bytecode;
    };
}
