/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import org.apache.openejb.client.ProtocolMetaData;

public class NameClassPairEnumeration<T extends NameClassPair>
implements NamingEnumeration<T>,
Externalizable {
    private static final long serialVersionUID = 5678570940990836625L;
    private transient List<NameClassPair> list;
    private transient Iterator<NameClassPair> iterator;
    private transient ProtocolMetaData metaData;

    public NameClassPairEnumeration(List<NameClassPair> list) {
        this.list = list;
        this.iterator = list.iterator();
    }

    public NameClassPairEnumeration() {
        this.list = Collections.EMPTY_LIST;
        this.iterator = this.list.iterator();
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void close() {
        this.iterator = null;
    }

    @Override
    public boolean hasMore() {
        return this.iterator.hasNext();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public T next() {
        return (T)this.iterator.next();
    }

    @Override
    public T nextElement() {
        return (T)this.next();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.list.size());
        for (NameClassPair pair : this.list) {
            out.writeObject(pair.getName());
            out.writeObject(pair.getClassName());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size;
        byte version = in.readByte();
        this.list = new ArrayList<NameClassPair>(size);
        for (size = in.readInt(); size > 0; --size) {
            String name = (String)in.readObject();
            String className = (String)in.readObject();
            this.list.add(new NameClassPair(name, className));
        }
        this.iterator = this.list.iterator();
    }
}

