/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.util.Map;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.threads.impl.ThreadContextProviderUtil;

public class TxThreadContextProvider
implements ThreadContextProvider,
Serializable {
    public static final TxThreadContextProvider INSTANCE = new TxThreadContextProvider();

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        try {
            return new TxThreadContextRestoringSnapshot(OpenEJB.getTransactionManager().getTransaction());
        }
        catch (SystemException e) {
            throw new OpenEJBRuntimeException((Exception)((Object)e));
        }
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return TxThreadContextClearingSnapshot.INSTANCE;
    }

    public String getThreadContextType() {
        return "Transaction";
    }

    public static class TxThreadContextRestoringSnapshot
    implements ThreadContextSnapshot {
        private final Transaction transaction;

        public TxThreadContextRestoringSnapshot(Transaction transaction) {
            this.transaction = transaction;
        }

        public ThreadContextRestorer begin() {
            TransactionManager transactionManager = OpenEJB.getTransactionManager();
            try {
                Transaction oldTransaction = transactionManager.suspend();
                transactionManager.resume(this.transaction);
                return new TxThreadContextRestorer(oldTransaction);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new OpenEJBRuntimeException((Exception)e);
            }
        }

        public String toString() {
            return "TxThreadContextRestoringSnapshot@" + System.identityHashCode(this) + "{transaction=" + this.transaction + "}";
        }
    }

    public static class TxThreadContextClearingSnapshot
    implements ThreadContextSnapshot,
    Serializable {
        public static final TxThreadContextClearingSnapshot INSTANCE = new TxThreadContextClearingSnapshot();

        public ThreadContextRestorer begin() {
            try {
                TransactionManager tm = OpenEJB.getTransactionManager();
                if (tm != null) {
                    return new TxThreadContextRestorer(tm.suspend());
                }
                return ThreadContextProviderUtil.NOOP_RESTORER;
            }
            catch (SystemException e) {
                throw new OpenEJBRuntimeException((Exception)((Object)e));
            }
        }
    }

    public static class TxThreadContextRestorer
    implements ThreadContextRestorer {
        private final Transaction transaction;

        public TxThreadContextRestorer(Transaction transaction) {
            this.transaction = transaction;
        }

        public void endContext() throws IllegalStateException {
            try {
                OpenEJB.getTransactionManager().resume(this.transaction);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new OpenEJBRuntimeException((Exception)e);
            }
        }

        public String toString() {
            return "TxThreadContextRestorer@" + System.identityHashCode(this) + "{transaction=" + this.transaction + "}";
        }
    }
}

