/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.observer;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.AfterEvent;
import org.apache.openejb.observer.event.BeforeEvent;
import org.apache.openejb.observer.event.ObserverAdded;
import org.apache.openejb.observer.event.ObserverFailed;
import org.apache.openejb.observer.event.ObserverRemoved;

public class ObserverManager {
    private static final ThreadLocal<Set<Invocation>> SEEN = new ThreadLocal<Set<Invocation>>(){

        @Override
        protected Set<Invocation> initialValue() {
            return new HashSet<Invocation>();
        }
    };
    private static final AtomicReference<Logger> LOGGER = new AtomicReference();
    private final Set<Observer> observers = new LinkedHashSet<Observer>();
    private final Map<Class, Invocation> methods = new ConcurrentHashMap<Class, Invocation>();
    private static final Invocation IGNORE = new Invocation(){

        @Override
        public void invoke(Object event) {
        }

        public String toString() {
            return "IGNORE";
        }
    };

    public boolean addObserver(Object observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        try {
            Observer wrapper = new Observer(observer);
            if (wrapper.after.size() + wrapper.before.size() + wrapper.methods.size() > 0 && this.observers.add(wrapper)) {
                this.methods.clear();
                this.fireEvent(new ObserverAdded(observer));
                return true;
            }
            return false;
        }
        catch (NotAnObserverException naoe) {
            return false;
        }
    }

    public boolean removeObserver(Object observer) {
        if (observer == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            if (this.observers.remove(new Observer(observer))) {
                this.methods.clear();
                this.fireEvent(new ObserverRemoved(observer));
                return true;
            }
            return false;
        }
        catch (NotAnObserverException naoe) {
            return false;
        }
    }

    public <E> E fireEvent(E event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        try {
            E e = this.doFire(event);
            return e;
        }
        finally {
            SEEN.remove();
        }
    }

    private <E> E doFire(E event) {
        Class<?> type = event.getClass();
        Invocation invocation = this.getInvocation(type);
        invocation.invoke(event);
        return event;
    }

    private Invocation getInvocation(Class<?> type) {
        Invocation invocation = this.methods.get(type);
        if (invocation != null) {
            return invocation;
        }
        invocation = this.buildInvocation(type);
        this.methods.put(type, invocation);
        return invocation;
    }

    public void destroy() {
        for (Observer o : new LinkedList<Observer>(this.observers)) {
            this.removeObserver(o.observer);
        }
    }

    private Invocation buildInvocation(Class<?> type) {
        Invocation before = this.buildInvocation(Phase.BEFORE, type);
        Invocation after = this.buildInvocation(Phase.AFTER, type);
        Invocation invoke = this.buildInvocation(Phase.INVOKE, type);
        if (IGNORE == before && IGNORE == after) {
            return invoke;
        }
        return new BeforeAndAfterInvocationSet(before, invoke, after);
    }

    private Invocation buildInvocation(Phase phase, Class<?> type) {
        InvocationList list = new InvocationList();
        for (Observer observer : this.observers) {
            Invocation method = observer.get(phase, type);
            if (method == null || method == IGNORE) continue;
            list.add(method);
        }
        switch (list.getInvocations().size()) {
            case 0: {
                return IGNORE;
            }
            case 1: {
                return list.getInvocations().get(0);
            }
        }
        return list;
    }

    private static Logger logger() {
        Logger value = LOGGER.get();
        if (value == null) {
            value = Logger.getLogger(ObserverManager.class.getName());
            LOGGER.set(value);
        }
        return value;
    }

    public class Observer {
        private final Map<Class, Invocation> before = new ConcurrentHashMap<Class, Invocation>();
        private final Map<Class, Invocation> methods = new ConcurrentHashMap<Class, Invocation>();
        private final Map<Class, Invocation> after = new ConcurrentHashMap<Class, Invocation>();
        private final Object observer;

        public Observer(Object observer) {
            if (observer == null) {
                throw new IllegalArgumentException("observer cannot be null");
            }
            HashSet<Method> methods = new HashSet<Method>();
            methods.addAll(Arrays.asList(observer.getClass().getMethods()));
            methods.addAll(Arrays.asList(observer.getClass().getDeclaredMethods()));
            this.observer = observer;
            for (Method method : methods) {
                Class parameterClass;
                if (!this.isObserver(method)) continue;
                if (method.getParameterTypes().length > 1) {
                    throw new IllegalArgumentException("@Observes method must have only 1 parameter: " + method.toString());
                }
                if (Modifier.isAbstract(method.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method must not be abstract: " + method.toString());
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method must not be static: " + method.toString());
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method must be public: " + method.toString());
                }
                Class<?> type = method.getParameterTypes()[0];
                if (AfterEvent.class.equals(type)) {
                    parameterClass = this.getParameterClass(method);
                    this.after.put(parameterClass, new AfterInvocation(method, observer));
                    continue;
                }
                if (BeforeEvent.class.equals(type)) {
                    parameterClass = this.getParameterClass(method);
                    this.before.put(parameterClass, new BeforeInvocation(method, observer));
                    continue;
                }
                this.validate(method, type);
                this.methods.put(type, new MethodInvocation(method, observer));
            }
            if (methods.isEmpty() && this.after.isEmpty() && this.before.isEmpty()) {
                throw new NotAnObserverException("Object has no @Observes methods. For example: public void observe(@Observes RetryConditionAdded event){...}");
            }
        }

        private Class getParameterClass(Method method) {
            Class<Object> clazz;
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Type generic = genericParameterTypes[0];
            if (!(generic instanceof ParameterizedType)) {
                Class<?> event = method.getParameterTypes()[0];
                throw new IllegalArgumentException("@Observes " + event.getSimpleName() + " missing generic type: " + method.toString());
            }
            ParameterizedType parameterized = (ParameterizedType)ParameterizedType.class.cast(generic);
            Type type = parameterized.getActualTypeArguments()[0];
            if (type instanceof Class) {
                clazz = (Class<Object>)Class.class.cast(type);
            } else if (type instanceof WildcardType) {
                clazz = Object.class;
            } else {
                Class<?> event = method.getParameterTypes()[0];
                throw new IllegalArgumentException("@Observes " + event.getSimpleName() + " unsupported generic type: " + type.getClass().getSimpleName() + "  " + method.toString());
            }
            this.validate(method, clazz);
            return clazz;
        }

        private void validate(Method method, Class<?> type) {
            if (type.isAnnotation()) {
                throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an annotation): " + method.toString());
            }
            if (type.isInterface()) {
                throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an interface): " + method.toString());
            }
            if (type.isArray()) {
                throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an array): " + method.toString());
            }
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not a primitive): " + method.toString());
            }
        }

        private Map<Class, Invocation> map(Phase event) {
            switch (event) {
                case AFTER: {
                    return this.after;
                }
                case BEFORE: {
                    return this.before;
                }
                case INVOKE: {
                    return this.methods;
                }
            }
            throw new IllegalStateException("Unknown Event style " + event);
        }

        public Invocation get(Phase event, Class eventType) {
            return this.get(this.map(event), eventType);
        }

        public Invocation getAfter(Class eventType) {
            return this.get(this.after, eventType);
        }

        public Invocation getBefore(Class eventType) {
            return this.get(this.before, eventType);
        }

        private Invocation get(Map<Class, Invocation> map, Class eventType) {
            if (eventType == null) {
                return IGNORE;
            }
            Invocation method = map.get(eventType);
            if (method != null) {
                return method;
            }
            return this.get(map, eventType.getSuperclass());
        }

        private boolean isObserver(Method method) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!annotation.annotationType().equals(Observes.class)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Observer observer1 = (Observer)o;
            return this.observer.equals(observer1.observer);
        }

        public int hashCode() {
            return this.observer.hashCode();
        }
    }

    public static class NotAnObserverException
    extends IllegalArgumentException {
        public NotAnObserverException(String s) {
            super(s);
        }
    }

    public static interface Invocation {
        public void invoke(Object var1);
    }

    private static enum Phase {
        BEFORE,
        INVOKE,
        AFTER;

    }

    private static final class BeforeAndAfterInvocationSet
    implements Invocation {
        private final Invocation before;
        private final Invocation invoke;
        private final Invocation after;

        private BeforeAndAfterInvocationSet(Invocation before, Invocation invoke, Invocation after) {
            this.before = before;
            this.invoke = invoke;
            this.after = after;
        }

        @Override
        public void invoke(Object event) {
            this.before.invoke(event);
            this.invoke.invoke(event);
            this.after.invoke(event);
        }
    }

    public static class InvocationList
    implements Invocation {
        private final List<Invocation> invocations = new LinkedList<Invocation>();

        public boolean add(Invocation invocation) {
            return this.invocations.add(invocation);
        }

        public List<Invocation> getInvocations() {
            return this.invocations;
        }

        @Override
        public void invoke(Object event) {
            for (Invocation invocation : this.invocations) {
                invocation.invoke(event);
            }
        }
    }

    private final class BeforeInvocation
    extends MethodInvocation {
        private BeforeInvocation(Method method, Object observer) {
            super(method, observer);
        }

        @Override
        public void invoke(final Object event) {
            super.invoke(new BeforeEvent(){

                public Object getEvent() {
                    return event;
                }

                public String toString() {
                    return "BeforeEvent{} " + event;
                }
            });
        }
    }

    private final class AfterInvocation
    extends MethodInvocation {
        private AfterInvocation(Method method, Object observer) {
            super(method, observer);
        }

        @Override
        public void invoke(final Object event) {
            super.invoke(new AfterEvent(){

                public Object getEvent() {
                    return event;
                }

                public String toString() {
                    return "AfterEvent{} " + event;
                }
            });
        }
    }

    public class MethodInvocation
    implements Invocation {
        private final Method method;
        private final Object observer;

        public MethodInvocation(Method method, Object observer) {
            this.method = method;
            this.observer = observer;
        }

        @Override
        public void invoke(Object event) {
            try {
                this.method.invoke(this.observer, event);
            }
            catch (InvocationTargetException e) {
                Throwable t;
                if (!SEEN.get().add(this)) {
                    return;
                }
                Throwable throwable = t = e.getTargetException() == null ? e : e.getTargetException();
                if (!(event instanceof ObserverFailed)) {
                    ObserverManager.this.doFire(new ObserverFailed(this.observer, this.method, event, t));
                }
                if (t instanceof InvocationTargetException && t.getCause() != null) {
                    ObserverManager.logger().log(Level.SEVERE, "error invoking " + this.observer, t.getCause());
                } else {
                    ObserverManager.logger().log(Level.SEVERE, "error invoking " + this.observer, t);
                }
            }
            catch (IllegalAccessException e) {
                ObserverManager.logger().log(Level.SEVERE, this.method + " can't be invoked, check it is public");
            }
        }

        public String toString() {
            return this.method.toString();
        }
    }
}

