/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.component;

import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.DestroyedComponentException;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.component.UninitializedComponentException;
import net.shibboleth.shared.component.UnmodifiableComponentException;

@ThreadSafe
public abstract class AbstractInitializableComponent
implements DestructableComponent,
InitializableComponent {
    @GuardedBy(value="this")
    private boolean isDestroyed;
    @GuardedBy(value="this")
    private boolean isInitialized;

    @Override
    public final synchronized boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public final synchronized void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        this.doDestroy();
        this.isDestroyed = true;
    }

    @Override
    public final synchronized void initialize() throws ComponentInitializationException {
        this.ifDestroyedThrowDestroyedComponentException();
        if (this.isInitialized()) {
            return;
        }
        this.doInitialize();
        this.isInitialized = true;
    }

    protected void ifDestroyedThrowDestroyedComponentException() {
        if (this.isDestroyed()) {
            throw new DestroyedComponentException("Unidentified Component has already been destroyed and can no longer be used.");
        }
    }

    protected void ifNotInitializedThrowUninitializedComponentException() {
        if (!this.isInitialized()) {
            throw new UninitializedComponentException("Unidentified Component has not yet been initialized and cannot be used.");
        }
    }

    protected void ifInitializedThrowUnmodifiabledComponentException() {
        if (this.isInitialized()) {
            throw new UnmodifiableComponentException("Unidentified Component has already been initialized and can no longer be modified");
        }
    }

    protected final void checkSetterPreconditions() {
        this.ifDestroyedThrowDestroyedComponentException();
        this.ifInitializedThrowUnmodifiabledComponentException();
    }

    protected final void checkComponentActive() {
        this.ifDestroyedThrowDestroyedComponentException();
        this.ifNotInitializedThrowUninitializedComponentException();
    }

    protected void doDestroy() {
    }

    protected void doInitialize() throws ComponentInitializationException {
    }
}

