/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.HTMLMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPPostEncoder
extends BaseSAML2MessageEncoder
implements HTMLMessageEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/saml2-post-binding.vm";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPPostEncoder.class);
    @NonnullAfterInit
    private VelocityEngine velocityEngine;
    @Nonnull
    private String velocityTemplateId = "/templates/saml2-post-binding.vm";
    @Nullable
    private StringDigester cspDigester;
    @Nullable
    private IdentifierGenerationStrategy cspNonceGenerator;

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(@Nullable VelocityEngine newVelocityEngine) {
        this.checkSetterPreconditions();
        this.velocityEngine = newVelocityEngine;
    }

    @Nonnull
    @NotEmpty
    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(@Nonnull @NotEmpty String newVelocityTemplateId) {
        this.checkSetterPreconditions();
        this.velocityTemplateId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newVelocityTemplateId), (String)"Velocity template ID cannot be null or empty");
    }

    public void setCSPDigester(@Nullable StringDigester digester) {
        this.checkSetterPreconditions();
        this.cspDigester = digester;
    }

    public void setCSPNonceGenerator(@Nullable IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.cspNonceGenerator = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.velocityEngine == null) {
            throw new ComponentInitializationException("VelocityEngine must be supplied");
        }
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (outboundMessage == null || !(outboundMessage instanceof SAMLObject)) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL(messageContext).toString();
        assert (endpointURL != null);
        this.postEncode(messageContext, endpointURL);
    }

    protected void postEncode(@Nonnull MessageContext messageContext, @Nonnull String endpointURL) throws MessageEncodingException {
        this.log.debug("Invoking Velocity template to create POST body");
        try {
            VelocityContext context = new VelocityContext();
            this.populateVelocityContext(context, messageContext, endpointURL);
            HttpServletResponse response = this.getHttpServletResponse();
            assert (response != null);
            context.put("response", (Object)response);
            HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
            HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
            HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/html");
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");){
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            this.log.error("Error invoking Velocity template: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    protected void populateVelocityContext(@Nonnull VelocityContext velocityContext, @Nonnull MessageContext messageContext, @Nonnull String endpointURL) throws MessageEncodingException {
        block9: {
            String encodedEndpointURL = HTMLEncoder.encodeForHTMLAttribute((String)endpointURL);
            this.log.debug("Encoding action url of '{}' with encoded value '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
            velocityContext.put("action", (Object)encodedEndpointURL);
            velocityContext.put("binding", (Object)this.getBindingURI());
            if (this.cspDigester != null) {
                this.log.trace("Adding CSP digester to context");
                velocityContext.put("cspDigester", (Object)this.cspDigester);
            }
            if (this.cspNonceGenerator != null) {
                this.log.trace("Adding CSP nonce generator to context");
                velocityContext.put("cspNonce", (Object)this.cspNonceGenerator);
            }
            SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
            assert (outboundMessage != null);
            this.log.debug("Marshalling and Base64 encoding SAML message");
            Element domMessage = this.marshallMessage((XMLObject)outboundMessage);
            try {
                String messageXML = SerializeSupport.nodeToString((Node)domMessage);
                String encodedMessage = Base64Support.encode((byte[])messageXML.getBytes("UTF-8"), (boolean)false);
                if (outboundMessage instanceof RequestAbstractType) {
                    velocityContext.put("SAMLRequest", (Object)encodedMessage);
                    break block9;
                }
                if (outboundMessage instanceof StatusResponseType) {
                    velocityContext.put("SAMLResponse", (Object)encodedMessage);
                    break block9;
                }
                throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant");
                throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
            }
            catch (EncodingException e) {
                this.log.error("Unable to base64 encode SAML message: {}", (Object)e.getMessage());
                throw new MessageEncodingException("Unable to base64 encode SAML message", (Exception)((Object)e));
            }
        }
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            String encodedRelayState = HTMLEncoder.encodeForHTMLAttribute((String)relayState);
            this.log.debug("Setting RelayState parameter to: '{}', encoded as '{}'", (Object)relayState, (Object)encodedRelayState);
            velocityContext.put("RelayState", (Object)encodedRelayState);
        }
    }
}

