/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.WhenThenNode;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CaseNode
extends Node
implements AliasableNode {
    private List<Node> whenClauses = null;

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = this.generateExpression(generationContext);
            reportQuery.addAttribute("Case", expression, (Class)this.getType());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Expression generateExpression(GenerationContext context) {
        void var4_8;
        LinkedHashMap<Expression, Expression> whenClauseMap = new LinkedHashMap<Expression, Expression>(this.whenClauses.size());
        for (WhenThenNode whenThenNode : this.whenClauses) {
            whenClauseMap.put(whenThenNode.generateExpressionForWhen(context), whenThenNode.generateExpressionForThen(context));
        }
        Object var4_5 = null;
        if (this.getLeft() == null) {
            Expression expression = context.getBaseExpression().caseStatement(whenClauseMap, this.getRight().generateExpression(context));
        } else {
            Expression expression = this.getLeft().generateExpression(context).caseStatement(whenClauseMap, this.getRight().generateExpression(context));
        }
        return var4_8;
    }

    @Override
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
        }
        this.right.validate(context);
        Iterator<Node> i = this.whenClauses.iterator();
        Class<Object> type = null;
        while (i.hasNext()) {
            Node node = i.next();
            node.validate(context);
            if (type == null) {
                type = node.getType();
                continue;
            }
            if (type.equals(node.getType())) continue;
            type = Object.class;
        }
        if (this.getRight().getType() != type) {
            type = typeHelper.getObjectType();
        }
        this.setType(type);
    }

    public List<Node> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<Node> whenClauses) {
        this.whenClauses = whenClauses;
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

