/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.event;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.MethodNotFoundException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.event.ValueChangeListener;

public class MethodExpressionValueChangeListener
implements ValueChangeListener,
StateHolder {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private MethodExpression methodExpressionOneArg;
    private MethodExpression methodExpressionZeroArg;
    private boolean isTransient = false;

    public MethodExpressionValueChangeListener() {
    }

    public MethodExpressionValueChangeListener(MethodExpression methodExpressionOneArg) {
        this.methodExpressionOneArg = methodExpressionOneArg;
        this._createZeroArgsMethodExpression(methodExpressionOneArg);
    }

    public MethodExpressionValueChangeListener(MethodExpression methodExpressionOneArg, MethodExpression methodExpressionZeroArg) {
        this.methodExpressionOneArg = methodExpressionOneArg;
        if (methodExpressionZeroArg != null) {
            this.methodExpressionZeroArg = methodExpressionZeroArg;
        } else {
            this._createZeroArgsMethodExpression(methodExpressionOneArg);
        }
    }

    @Override
    public void processValueChange(ValueChangeEvent event) throws AbortProcessingException {
        try {
            try {
                Object[] params = new Object[]{event};
                this.methodExpressionOneArg.invoke(this.getElContext(), params);
            }
            catch (MethodNotFoundException mnfe) {
                this.methodExpressionZeroArg.invoke(this.getElContext(), EMPTY_PARAMS);
            }
        }
        catch (ELException e) {
            Throwable cause = e.getCause();
            AbortProcessingException ape = null;
            if (cause != null) {
                do {
                    if (!(cause instanceof AbortProcessingException)) continue;
                    ape = (AbortProcessingException)cause;
                    break;
                } while ((cause = cause.getCause()) != null);
            }
            if (ape != null) {
                throw ape;
            }
            throw e;
        }
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        this.methodExpressionOneArg = (MethodExpression)((Object[])state)[0];
        this.methodExpressionZeroArg = (MethodExpression)((Object[])state)[1];
    }

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{this.methodExpressionOneArg, this.methodExpressionZeroArg};
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    private ELContext getElContext() {
        return this.getFacesContext().getELContext();
    }

    private FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    private void _createZeroArgsMethodExpression(MethodExpression methodExpression) {
        ExpressionFactory expressionFactory = this.getFacesContext().getApplication().getExpressionFactory();
        this.methodExpressionZeroArg = expressionFactory.createMethodExpression(this.getElContext(), methodExpression.getExpressionString(), Void.class, (Class[])EMPTY_CLASS_ARRAY);
    }
}

