/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class GetAction
extends AbstractRutaAction {
    private ListExpression<IRutaExpression> listExpr;
    private String var;
    private IStringExpression opExpr;

    public GetAction(ListExpression<IRutaExpression> f, String string, IStringExpression op) {
        this.listExpr = f;
        this.var = string;
        this.opExpr = op;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        context.getRuleMatch();
        RuleElement element = context.getElement();
        RutaBlock parent = element.getParent();
        String op = this.opExpr.getStringValue(context, stream);
        List<IRutaExpression> list = this.listExpr.getList(context, stream);
        if ("dominant".equals(op)) {
            parent.getEnvironment().setVariableValue(this.var, this.getDominant(list, parent));
        }
    }

    private Object getDominant(List<?> list, RutaBlock parent) {
        ArrayList objs = new ArrayList();
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (Object each : list) {
            Object value = each;
            if (objs.contains(value)) {
                int indexOf = objs.indexOf(value);
                Integer i = (Integer)counts.get(indexOf);
                i = i + 1;
                counts.set(indexOf, i);
                continue;
            }
            counts.add(1);
            objs.add(each);
        }
        Object dominant = null;
        int dominantCount = -1;
        int i = 0;
        for (Object each : objs) {
            int count;
            if ((count = ((Integer)counts.get(i++)).intValue()) <= dominantCount) continue;
            dominantCount = count;
            dominant = each;
        }
        return dominant;
    }

    public ListExpression<IRutaExpression> getListExpr() {
        return this.listExpr;
    }

    public String getVar() {
        return this.var;
    }

    public IStringExpression getOpExpr() {
        return this.opExpr;
    }
}

