/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.EmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.TOP;

public abstract class FloatList
extends TOP
implements CommonList,
Iterable<Float> {
    protected FloatList() {
    }

    public FloatList(JCas jcas) {
        super(jcas);
    }

    public FloatList(TypeImpl t, CASImpl c) {
        super(t, c);
    }

    public float getNthElement(int i) {
        return ((NonEmptyFloatList)this.getNonEmptyNthNode(i)).getHead();
    }

    @Override
    public NonEmptyFloatList createNonEmptyNode() {
        return new NonEmptyFloatList((JCas)this._casView.getJCasImpl());
    }

    public NonEmptyFloatList push(float item) {
        return new NonEmptyFloatList(this._casView.getJCasImpl(), item, this);
    }

    @Override
    public Iterator<Float> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public EmptyFloatList emptyList() {
        return this._casView.emptyFloatList();
    }

    public static FloatList create(JCas jcas, Float[] a) {
        FloatList floatList = jcas.getCasImpl().emptyFloatList();
        for (int i = a.length - 1; i >= 0; --i) {
            floatList = floatList.push(a[i].floatValue());
        }
        return floatList;
    }

    public Stream<Float> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean contains(float v) {
        FloatList node = this;
        while (node instanceof NonEmptyFloatList) {
            NonEmptyFloatList n = (NonEmptyFloatList)node;
            if (n.getHead() == v) {
                return true;
            }
            node = n.getTail();
        }
        return false;
    }
}

