/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cpm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;

public class PerformanceReportDialog
extends JDialog {
    private static final long serialVersionUID = 7747258424181047062L;
    private JLabel statusLabel = new JLabel("Processing completed successfully.");
    private JLabel docsProcessedLabel = new JLabel("Documents Processed: 0");
    private JLabel totalTimeLabel = new JLabel("Total Time: 0.0 seconds");
    private JTree tree = new JTree();
    private Map mEventTypeMap;

    public PerformanceReportDialog(Frame aFrame) throws HeadlessException {
        super(aFrame, true);
        this.setTitle("Performance Report");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel messagePanel = new JPanel();
        this.getContentPane().add((Component)messagePanel, "North");
        messagePanel.setLayout(new GridLayout(3, 1));
        messagePanel.add(this.statusLabel);
        messagePanel.add(this.docsProcessedLabel);
        messagePanel.add(this.totalTimeLabel);
        this.getContentPane().add((Component)this.tree, "Center");
        this.pack();
        this.setSize(400, 400);
        this.mEventTypeMap = new HashMap();
        this.mEventTypeMap.put("ANALYSIS_ENGINE", "TAE");
        this.mEventTypeMap.put("ANALYSIS", "Annotator");
        this.mEventTypeMap.put("CAS_PROCESSOR", "CAS Consumer");
    }

    public void displayStats(ProcessTrace aProcessTrace, int aNumDocsProcessed, String aStatusMessage) {
        this.statusLabel.setText(aStatusMessage);
        this.docsProcessedLabel.setText("Documents Processed: " + aNumDocsProcessed);
        long totalTime = 0L;
        for (ProcessTraceEvent event : aProcessTrace.getEvents()) {
            totalTime += (long)event.getDuration();
        }
        double totalTimeSeconds = (double)totalTime / 1000.0;
        this.totalTimeLabel.setText("Total Time: " + totalTimeSeconds + " seconds");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("100% (" + totalTime + "ms) - Collection Processing Engine");
        for (ProcessTraceEvent event : aProcessTrace.getEvents()) {
            this.buildEventTree(event, root, totalTime);
        }
        this.tree.setModel(new DefaultTreeModel(root));
        this.setVisible(true);
    }

    public void buildEventTree(ProcessTraceEvent aEvent, DefaultMutableTreeNode aParentNode, long aTotalTime) {
        DecimalFormat pctFmt = new DecimalFormat("##.##%");
        long duration = aEvent.getDuration();
        double pct = aTotalTime != 0L ? (double)duration / (double)aTotalTime : 0.0;
        String pctStr = pctFmt.format(pct);
        String type = (String)this.mEventTypeMap.get(aEvent.getType());
        if (type == null) {
            type = aEvent.getType();
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(pctStr + " (" + duration + "ms) - " + aEvent.getComponentName() + " (" + type + ")");
        aParentNode.add(node);
        for (ProcessTraceEvent event : aEvent.getSubEvents()) {
            this.buildEventTree(event, node, aTotalTime);
        }
    }
}

