/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.filesystem;

import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.uniffle.common.security.SecurityContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFilesystemProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFilesystemProvider.class);

    public static FileSystem getFilesystem(Path path, Configuration configuration) throws Exception {
        return HadoopFilesystemProvider.getFilesystem(SecurityContextFactory.get().getSecurityContext().getContextLoginUser(), path, configuration);
    }

    public static FileSystem getFilesystem(String user, Path path, Configuration configuration) throws Exception {
        UserGroupInformation.AuthenticationMethod authenticationMethod = SecurityUtil.getAuthenticationMethod((Configuration)configuration);
        boolean needSecurity = authenticationMethod != UserGroupInformation.AuthenticationMethod.SIMPLE;
        Callable<FileSystem> callable = () -> FileSystem.get((URI)path.toUri(), (Configuration)configuration);
        FileSystem fileSystem = needSecurity ? SecurityContextFactory.get().getSecurityContext().runSecured(user, callable) : callable.call();
        if (fileSystem instanceof LocalFileSystem) {
            LOGGER.debug("{} is local file system", (Object)path);
            return ((LocalFileSystem)fileSystem).getRawFileSystem();
        }
        return fileSystem;
    }
}

