/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.client.impl.grpc.ShuffleServerInternalGrpcClient;
import org.apache.uniffle.client.request.RssCancelDecommissionRequest;
import org.apache.uniffle.client.request.RssDecommissionRequest;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.InvalidRequestException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.apache.uniffle.guava.annotations.VisibleForTesting;
import org.apache.uniffle.guava.cache.Cache;
import org.apache.uniffle.guava.cache.CacheBuilder;
import org.apache.uniffle.guava.collect.Lists;
import org.apache.uniffle.guava.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClusterManager
implements ClusterManager {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleClusterManager.class);
    private final Map<String, ServerNode> servers = JavaUtils.newConcurrentMap();
    private final Cache<ServerNode, ShuffleServerInternalGrpcClient> clientCache;
    private Set<String> excludeNodes = Sets.newConcurrentHashSet();
    Set<ServerNode> lostNodes = Sets.newHashSet();
    Set<ServerNode> unhealthyNodes = Sets.newHashSet();
    private Map<String, Set<ServerNode>> tagToNodes = JavaUtils.newConcurrentMap();
    private AtomicLong excludeLastModify = new AtomicLong(0L);
    private long heartbeatTimeout;
    private volatile int shuffleNodesMax;
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledExecutorService checkNodesExecutorService;
    private FileSystem hadoopFileSystem;
    private long outputAliveServerCount = 0L;
    private final long periodicOutputIntervalTimes;
    private long startTime;
    private boolean startupSilentPeriodEnabled;
    private long startupSilentPeriodDurationMs;
    private boolean readyForServe = false;

    public SimpleClusterManager(CoordinatorConf conf, Configuration hadoopConf) throws Exception {
        this.shuffleNodesMax = conf.getInteger(CoordinatorConf.COORDINATOR_SHUFFLE_NODES_MAX);
        this.heartbeatTimeout = conf.getLong(CoordinatorConf.COORDINATOR_HEARTBEAT_TIMEOUT);
        this.scheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"SimpleClusterManager");
        this.startupSilentPeriodEnabled = (Boolean)conf.get(CoordinatorConf.COORDINATOR_START_SILENT_PERIOD_ENABLED);
        this.startupSilentPeriodDurationMs = (Long)conf.get(CoordinatorConf.COORDINATOR_START_SILENT_PERIOD_DURATION);
        this.periodicOutputIntervalTimes = (Long)conf.get(CoordinatorConf.COORDINATOR_NODES_PERIODIC_OUTPUT_INTERVAL_TIMES);
        this.scheduledExecutorService.scheduleAtFixedRate(this::nodesCheck, this.heartbeatTimeout / 3L, this.heartbeatTimeout / 3L, TimeUnit.MILLISECONDS);
        String excludeNodesPath = conf.getString(CoordinatorConf.COORDINATOR_EXCLUDE_NODES_FILE_PATH, "");
        if (!StringUtils.isEmpty((CharSequence)excludeNodesPath)) {
            this.hadoopFileSystem = HadoopFilesystemProvider.getFilesystem((Path)new Path(excludeNodesPath), (Configuration)hadoopConf);
            long updateNodesInterval = conf.getLong(CoordinatorConf.COORDINATOR_EXCLUDE_NODES_CHECK_INTERVAL);
            this.checkNodesExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"UpdateExcludeNodes");
            this.checkNodesExecutorService.scheduleAtFixedRate(() -> this.updateExcludeNodes(excludeNodesPath), 0L, updateNodesInterval, TimeUnit.MILLISECONDS);
        }
        long clientExpiredTime = (Long)conf.get(CoordinatorConf.COORDINATOR_NODES_CLIENT_CACHE_EXPIRED);
        int maxClient = (Integer)conf.get(CoordinatorConf.COORDINATOR_NODES_CLIENT_CACHE_MAX);
        this.clientCache = CacheBuilder.newBuilder().expireAfterAccess(clientExpiredTime, TimeUnit.MILLISECONDS).maximumSize(maxClient).removalListener(notify -> ((ShuffleServerInternalGrpcClient)notify.getValue()).close()).build();
        this.startTime = System.currentTimeMillis();
    }

    void nodesCheck() {
        try {
            long timestamp = System.currentTimeMillis();
            for (ServerNode sn : this.servers.values()) {
                if (timestamp - sn.getTimestamp() > this.heartbeatTimeout) {
                    LOG.warn("Heartbeat timeout detect, {} will be removed from node list.", (Object)sn);
                    sn.setStatus(ServerStatus.LOST);
                    this.lostNodes.add(sn);
                    continue;
                }
                if (ServerStatus.UNHEALTHY.equals((Object)sn.getStatus())) {
                    LOG.warn("Found server {} was unhealthy, will not assign it.", (Object)sn);
                    this.unhealthyNodes.add(sn);
                    this.lostNodes.remove(sn);
                    continue;
                }
                this.lostNodes.remove(sn);
                this.unhealthyNodes.remove(sn);
            }
            for (ServerNode server : this.lostNodes) {
                ServerNode sn = this.servers.remove(server.getId());
                this.unhealthyNodes.remove(sn);
                if (sn == null) continue;
                this.clientCache.invalidate(sn);
                for (Set<ServerNode> nodesWithTag : this.tagToNodes.values()) {
                    nodesWithTag.remove(sn);
                }
            }
            if (!this.lostNodes.isEmpty() || this.outputAliveServerCount % this.periodicOutputIntervalTimes == 0L) {
                LOG.info("Alive servers number: {}, ids: {}", (Object)this.servers.size(), this.servers.keySet().stream().collect(Collectors.toList()));
            }
            ++this.outputAliveServerCount;
            CoordinatorMetrics.gaugeUnhealthyServerNum.set((double)this.unhealthyNodes.size());
            CoordinatorMetrics.gaugeTotalServerNum.set((double)this.servers.size());
        }
        catch (Exception e) {
            LOG.warn("Error happened in nodesCheck", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void nodesCheckTest() {
        this.nodesCheck();
    }

    private void updateExcludeNodes(String path) {
        int originalExcludeNodesNumber = this.excludeNodes.size();
        try {
            Path hadoopPath = new Path(path);
            FileStatus fileStatus = this.hadoopFileSystem.getFileStatus(hadoopPath);
            if (fileStatus != null && fileStatus.isFile()) {
                long latestModificationTime = fileStatus.getModificationTime();
                if (this.excludeLastModify.get() != latestModificationTime) {
                    this.parseExcludeNodesFile((DataInputStream)this.hadoopFileSystem.open(hadoopPath));
                    this.excludeLastModify.set(latestModificationTime);
                }
            } else {
                this.excludeNodes = Sets.newConcurrentHashSet();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.excludeNodes = Sets.newConcurrentHashSet();
        }
        catch (Exception e) {
            LOG.warn("Error when updating exclude nodes, the exclude nodes file path: {}.", (Object)path, (Object)e);
        }
        int newlyExcludeNodesNumber = this.excludeNodes.size();
        if (newlyExcludeNodesNumber != originalExcludeNodesNumber) {
            LOG.info("Exclude nodes number: {}, nodes list: {}", (Object)newlyExcludeNodesNumber, this.excludeNodes);
        }
        CoordinatorMetrics.gaugeExcludeServerNum.set((double)this.excludeNodes.size());
    }

    private void parseExcludeNodesFile(DataInputStream fsDataInputStream) throws IOException {
        Set<String> nodes = Sets.newConcurrentHashSet();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fsDataInputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line) || line.trim().startsWith("#")) continue;
                nodes.add(line.trim());
            }
        }
        this.excludeNodes = nodes;
        LOG.info("Updated exclude nodes and {} nodes were marked as exclude nodes", (Object)this.excludeNodes.size());
    }

    @Override
    public void add(ServerNode node) {
        if (!this.servers.containsKey(node.getId())) {
            LOG.info("Newly registering node: {}", (Object)node.getId());
        }
        this.servers.put(node.getId(), node);
        Set<String> tags = node.getTags();
        for (Set<ServerNode> nodes : this.tagToNodes.values()) {
            nodes.remove(node);
        }
        for (String tag : tags) {
            this.tagToNodes.computeIfAbsent(tag, key -> Sets.newConcurrentHashSet());
            this.tagToNodes.get(tag).add(node);
        }
    }

    @Override
    public List<ServerNode> getServerList(Set<String> requiredTags) {
        ArrayList<ServerNode> availableNodes = Lists.newArrayList();
        for (ServerNode node : this.servers.values()) {
            if (!ServerStatus.ACTIVE.equals((Object)node.getStatus()) || this.excludeNodes.contains(node.getId()) || !node.getTags().containsAll(requiredTags)) continue;
            availableNodes.add(node);
        }
        return availableNodes;
    }

    @Override
    public List<ServerNode> getLostServerList() {
        return Lists.newArrayList(this.lostNodes);
    }

    @Override
    public List<ServerNode> getUnhealthyServerList() {
        return Lists.newArrayList(this.unhealthyNodes);
    }

    public Set<String> getExcludeNodes() {
        return this.excludeNodes;
    }

    public Map<String, Set<ServerNode>> getTagToNodes() {
        return this.tagToNodes;
    }

    @Override
    public int getNodesNum() {
        return this.servers.size();
    }

    @Override
    public List<ServerNode> list() {
        return Lists.newArrayList(this.servers.values());
    }

    @VisibleForTesting
    public void clear() {
        this.servers.clear();
    }

    @Override
    public int getShuffleNodesMax() {
        return this.shuffleNodesMax;
    }

    @Override
    public boolean isReadyForServe() {
        if (!this.startupSilentPeriodEnabled) {
            return true;
        }
        if (!this.readyForServe && System.currentTimeMillis() - this.startTime > this.startupSilentPeriodDurationMs) {
            this.readyForServe = true;
        }
        return this.readyForServe;
    }

    @Override
    public void decommission(String serverId) {
        ServerNode serverNode = this.getServerNodeById(serverId);
        this.getShuffleServerClient(serverNode).decommission(new RssDecommissionRequest());
    }

    @Override
    public void cancelDecommission(String serverId) {
        ServerNode serverNode = this.getServerNodeById(serverId);
        this.getShuffleServerClient(serverNode).cancelDecommission(new RssCancelDecommissionRequest());
    }

    private ShuffleServerInternalGrpcClient getShuffleServerClient(ServerNode serverNode) {
        try {
            return this.clientCache.get(serverNode, () -> new ShuffleServerInternalGrpcClient(serverNode.getIp(), serverNode.getGrpcPort()));
        }
        catch (ExecutionException e) {
            throw new RssException((Throwable)e);
        }
    }

    @Override
    public ServerNode getServerNodeById(String serverId) {
        ServerNode serverNode = this.servers.get(serverId);
        if (serverNode == null) {
            throw new InvalidRequestException("Server Id [" + serverId + "] not found!");
        }
        return serverNode;
    }

    @Override
    public void close() throws IOException {
        if (this.hadoopFileSystem != null) {
            this.hadoopFileSystem.close();
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        if (this.checkNodesExecutorService != null) {
            this.checkNodesExecutorService.shutdown();
        }
    }

    @VisibleForTesting
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @VisibleForTesting
    public void setReadyForServe(boolean readyForServe) {
        this.readyForServe = readyForServe;
    }

    @VisibleForTesting
    public void setStartupSilentPeriodEnabled(boolean startupSilentPeriodEnabled) {
        this.startupSilentPeriodEnabled = startupSilentPeriodEnabled;
    }

    @VisibleForTesting
    public Map<String, ServerNode> getServers() {
        return this.servers;
    }

    public void reconfigure(RssConf conf) {
        int nodeMax = conf.getInteger(CoordinatorConf.COORDINATOR_SHUFFLE_NODES_MAX);
        if (nodeMax != this.shuffleNodesMax) {
            LOG.warn("Coordinator update new shuffleNodesMax {}", (Object)nodeMax);
            this.shuffleNodesMax = nodeMax;
        }
    }

    public boolean isPropertyReconfigurable(String property) {
        return CoordinatorConf.COORDINATOR_SHUFFLE_NODES_MAX.key().equals(property);
    }
}

