/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.access.checker;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.coordinator.AccessManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.access.AccessCheckResult;
import org.apache.uniffle.coordinator.access.AccessInfo;
import org.apache.uniffle.coordinator.access.checker.AbstractAccessChecker;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.apache.uniffle.guava.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessCandidatesChecker
extends AbstractAccessChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AccessCandidatesChecker.class);
    private final AtomicReference<Set<String>> candidates = new AtomicReference();
    private final AtomicLong lastCandidatesUpdateMS = new AtomicLong(0L);
    private final Path path;
    private final ScheduledExecutorService updateAccessCandidatesSES;
    private final FileSystem fileSystem;

    public AccessCandidatesChecker(AccessManager accessManager) throws Exception {
        super(accessManager);
        CoordinatorConf conf = accessManager.getCoordinatorConf();
        String pathStr = (String)conf.get(CoordinatorConf.COORDINATOR_ACCESS_CANDIDATES_PATH);
        this.path = new Path(pathStr);
        Configuration hadoopConf = accessManager.getHadoopConf();
        this.fileSystem = HadoopFilesystemProvider.getFilesystem((Path)this.path, (Configuration)hadoopConf);
        if (!this.fileSystem.isFile(this.path)) {
            String msg = String.format("Fail to init AccessCandidatesChecker, %s is not a file.", this.path.toUri());
            LOG.error(msg);
            throw new RssException(msg);
        }
        this.updateAccessCandidatesInternal();
        if (this.candidates.get() == null || this.candidates.get().isEmpty()) {
            String msg = "Candidates must be non-empty and can be loaded successfully at coordinator startup.";
            LOG.error(msg);
            throw new RssException(msg);
        }
        LOG.debug("Load candidates: {}", (Object)String.join((CharSequence)";", (Iterable<? extends CharSequence>)this.candidates.get()));
        int updateIntervalS = conf.getInteger(CoordinatorConf.COORDINATOR_ACCESS_CANDIDATES_UPDATE_INTERVAL_SEC);
        this.updateAccessCandidatesSES = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"UpdateAccessCandidates");
        this.updateAccessCandidatesSES.scheduleAtFixedRate(this::updateAccessCandidates, 0L, updateIntervalS, TimeUnit.SECONDS);
    }

    @Override
    public AccessCheckResult check(AccessInfo accessInfo) {
        String accessId = accessInfo.getAccessId().trim();
        if (!this.candidates.get().contains(accessId)) {
            String msg = String.format("Denied by AccessCandidatesChecker, accessInfo[%s].", accessInfo);
            LOG.debug("Candidates is {}, {}", this.candidates.get(), (Object)msg);
            CoordinatorMetrics.counterTotalCandidatesDeniedRequest.inc();
            return new AccessCheckResult(false, msg);
        }
        return new AccessCheckResult(true, "SUCCESS");
    }

    @Override
    public void close() {
        if (this.updateAccessCandidatesSES != null) {
            this.updateAccessCandidatesSES.shutdownNow();
        }
    }

    private void updateAccessCandidates() {
        try {
            Object[] fileStatus = this.fileSystem.listStatus(this.path);
            if (!ArrayUtils.isEmpty((Object[])fileStatus)) {
                long lastModifiedMS = fileStatus[0].getModificationTime();
                if (this.lastCandidatesUpdateMS.get() != lastModifiedMS) {
                    this.updateAccessCandidatesInternal();
                    this.lastCandidatesUpdateMS.set(lastModifiedMS);
                    LOG.debug("Load candidates: {}", (Object)String.join((CharSequence)";", (Iterable<? extends CharSequence>)this.candidates.get()));
                }
            } else {
                LOG.warn("Candidates file not found.");
            }
        }
        catch (Exception e) {
            LOG.warn("Error when update access candidates, ignore this updating.", (Throwable)e);
        }
    }

    private void updateAccessCandidatesInternal() {
        HashSet<String> newCandidates = Sets.newHashSet();
        String content = this.loadFileContent();
        if (StringUtils.isEmpty((CharSequence)content)) {
            LOG.warn("Load empty content from {}, ignore this updating", (Object)this.path.toUri().toString());
            return;
        }
        for (String item : content.split("\n")) {
            String accessId = item.trim();
            if (StringUtils.isEmpty((CharSequence)accessId)) continue;
            newCandidates.add(accessId);
        }
        if (newCandidates.isEmpty()) {
            LOG.warn("Empty content in {}, ignore this updating.", (Object)this.path.toUri().toString());
            return;
        }
        this.candidates.set(newCandidates);
    }

    private String loadFileContent() {
        String content = null;
        try (FSDataInputStream in = this.fileSystem.open(this.path);){
            content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Fail to load content from {}", (Object)this.path.toUri().toString());
        }
        return content;
    }

    public AtomicReference<Set<String>> getCandidates() {
        return this.candidates;
    }
}

