/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import java.util.List;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(WriterBuffer.class);
    private long copyTime = 0L;
    private byte[] buffer;
    private int bufferSize;
    private int nextOffset = 0;
    private List<WrappedBuffer> buffers = Lists.newArrayList();
    private int dataLength = 0;
    private int memoryUsed = 0;

    public WriterBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void addRecord(byte[] recordBuffer, int length) {
        if (this.askForMemory(length)) {
            if (this.nextOffset > 0) {
                this.buffers.add(new WrappedBuffer(this.buffer, this.nextOffset));
                this.nextOffset = 0;
            }
            int newBufferSize = Math.max(length, this.bufferSize);
            this.buffer = new byte[newBufferSize];
            this.memoryUsed += newBufferSize;
        }
        try {
            System.arraycopy(recordBuffer, 0, this.buffer, this.nextOffset, length);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception for System.arraycopy, length[" + length + "], nextOffset[" + this.nextOffset + "], bufferSize[" + this.bufferSize + "]");
            throw e;
        }
        this.nextOffset += length;
        this.dataLength += length;
    }

    public boolean askForMemory(long length) {
        return this.buffer == null || (long)this.nextOffset + length > (long)this.bufferSize;
    }

    public byte[] getData() {
        byte[] data = new byte[this.dataLength];
        int offset = 0;
        long start = System.currentTimeMillis();
        for (WrappedBuffer wrappedBuffer : this.buffers) {
            System.arraycopy(wrappedBuffer.getBuffer(), 0, data, offset, wrappedBuffer.getSize());
            offset += wrappedBuffer.getSize();
        }
        System.arraycopy(this.buffer, 0, data, offset, this.nextOffset);
        this.copyTime += System.currentTimeMillis() - start;
        return data;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public long getCopyTime() {
        return this.copyTime;
    }

    public int getMemoryUsed() {
        return this.memoryUsed;
    }

    private static final class WrappedBuffer {
        byte[] buffer;
        int size;

        WrappedBuffer(byte[] buffer, int size) {
            this.buffer = buffer;
            this.size = size;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getSize() {
            return this.size;
        }
    }
}

