/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.security;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.security.SecurityContext;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopSecurityContext
implements SecurityContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopSecurityContext.class);
    private static final String KRB5_CONF_KEY = "java.security.krb5.conf";
    private UserGroupInformation loginUgi;
    private ScheduledExecutorService refreshScheduledExecutor;
    private Map<String, UserGroupInformation> proxyUserUgiPool;

    public HadoopSecurityContext(String krb5ConfPath, String keytabFile, String principal, long refreshIntervalSec) throws Exception {
        if (StringUtils.isEmpty((CharSequence)keytabFile)) {
            throw new IllegalArgumentException("KeytabFilePath must be not null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)principal)) {
            throw new IllegalArgumentException("principal must be not null or empty");
        }
        if (refreshIntervalSec <= 0L) {
            throw new IllegalArgumentException("refreshIntervalSec must be not negative");
        }
        if (StringUtils.isNotEmpty((CharSequence)krb5ConfPath)) {
            System.setProperty(KRB5_CONF_KEY, krb5ConfPath);
        }
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.loginUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytabFile);
        LOGGER.info("Got Kerberos ticket, keytab [{}], principal [{}], user [{}]", new Object[]{keytabFile, principal, this.loginUgi.getShortUserName()});
        this.refreshScheduledExecutor = ThreadUtils.getDaemonSingleThreadScheduledExecutor("Kerberos-refresh");
        this.refreshScheduledExecutor.scheduleAtFixedRate(this::authRefresh, refreshIntervalSec, refreshIntervalSec, TimeUnit.SECONDS);
        this.proxyUserUgiPool = JavaUtils.newConcurrentMap();
    }

    private void authRefresh() {
        try {
            LOGGER.info("Renewing kerberos token.");
            this.loginUgi.checkTGTAndReloginFromKeytab();
        }
        catch (Throwable t) {
            LOGGER.error("Error in token renewal task: ", t);
        }
    }

    @Override
    public <T> T runSecured(String user, Callable<T> securedCallable) throws Exception {
        if (StringUtils.isEmpty((CharSequence)user)) {
            throw new Exception("User must be not null or empty");
        }
        if (!user.equals(this.loginUgi.getShortUserName())) {
            UserGroupInformation proxyUserUgi = this.proxyUserUgiPool.computeIfAbsent(user, x -> UserGroupInformation.createProxyUser((String)x, (UserGroupInformation)this.loginUgi));
            return this.executeWithUgiWrapper(proxyUserUgi, securedCallable);
        }
        return this.executeWithUgiWrapper(this.loginUgi, securedCallable);
    }

    @Override
    public String getContextLoginUser() {
        return this.loginUgi.getShortUserName();
    }

    private <T> T executeWithUgiWrapper(UserGroupInformation ugi, Callable<T> callable) throws Exception {
        return (T)ugi.doAs(callable::call);
    }

    @VisibleForTesting
    Map<String, UserGroupInformation> getProxyUserUgiPool() {
        return this.proxyUserUgiPool;
    }

    @Override
    public void close() throws IOException {
        if (this.refreshScheduledExecutor != null) {
            this.refreshScheduledExecutor.shutdown();
        }
        if (this.proxyUserUgiPool != null) {
            this.proxyUserUgiPool.clear();
            this.proxyUserUgiPool = null;
        }
    }
}

