/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl.grpc;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.impl.grpc.GrpcClient;
import org.apache.uniffle.client.request.RssAppHeartBeatRequest;
import org.apache.uniffle.client.request.RssFinishShuffleRequest;
import org.apache.uniffle.client.request.RssGetInMemoryShuffleDataRequest;
import org.apache.uniffle.client.request.RssGetShuffleDataRequest;
import org.apache.uniffle.client.request.RssGetShuffleIndexRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultForMultiPartRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultRequest;
import org.apache.uniffle.client.request.RssRegisterShuffleRequest;
import org.apache.uniffle.client.request.RssReportShuffleResultRequest;
import org.apache.uniffle.client.request.RssSendCommitRequest;
import org.apache.uniffle.client.request.RssSendShuffleDataRequest;
import org.apache.uniffle.client.request.RssUnregisterShuffleRequest;
import org.apache.uniffle.client.response.RssAppHeartBeatResponse;
import org.apache.uniffle.client.response.RssFinishShuffleResponse;
import org.apache.uniffle.client.response.RssGetInMemoryShuffleDataResponse;
import org.apache.uniffle.client.response.RssGetShuffleDataResponse;
import org.apache.uniffle.client.response.RssGetShuffleIndexResponse;
import org.apache.uniffle.client.response.RssGetShuffleResultResponse;
import org.apache.uniffle.client.response.RssRegisterShuffleResponse;
import org.apache.uniffle.client.response.RssReportShuffleResultResponse;
import org.apache.uniffle.client.response.RssSendCommitResponse;
import org.apache.uniffle.client.response.RssSendShuffleDataResponse;
import org.apache.uniffle.client.response.RssUnregisterShuffleResponse;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.apache.uniffle.com.google.protobuf.ByteString;
import org.apache.uniffle.com.google.protobuf.UnsafeByteOperations;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.exception.NotRetryException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.RetryUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleServerGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerGrpcClient
extends GrpcClient
implements ShuffleServerClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerGrpcClient.class);
    protected static final long FAILED_REQUIRE_ID = -1L;
    protected static final long RPC_TIMEOUT_DEFAULT_MS = 60000L;
    private long rpcTimeout = 60000L;
    private ShuffleServerGrpc.ShuffleServerBlockingStub blockingStub = ShuffleServerGrpc.newBlockingStub(this.channel);

    public ShuffleServerGrpcClient(String host, int port) {
        this(host, port, 3);
    }

    public ShuffleServerGrpcClient(String host, int port, int maxRetryAttempts) {
        this(host, port, maxRetryAttempts, true);
    }

    public ShuffleServerGrpcClient(String host, int port, int maxRetryAttempts, boolean usePlaintext) {
        super(host, port, maxRetryAttempts, usePlaintext);
    }

    public ShuffleServerGrpc.ShuffleServerBlockingStub getBlockingStub() {
        return (ShuffleServerGrpc.ShuffleServerBlockingStub)this.blockingStub.withDeadlineAfter(this.rpcTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getDesc() {
        return "Shuffle server grpc client ref " + this.host + ":" + this.port;
    }

    private RssProtos.ShuffleRegisterResponse doRegisterShuffle(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite) {
        RssProtos.ShuffleRegisterRequest.Builder reqBuilder = RssProtos.ShuffleRegisterRequest.newBuilder();
        reqBuilder.setAppId(appId).setShuffleId(shuffleId).setUser(user).setShuffleDataDistribution(RssProtos.DataDistribution.valueOf(dataDistributionType.name())).setMaxConcurrencyPerPartitionToWrite(maxConcurrencyPerPartitionToWrite).addAllPartitionRanges(this.toShufflePartitionRanges(partitionRanges));
        RssProtos.RemoteStorage.Builder rsBuilder = RssProtos.RemoteStorage.newBuilder();
        rsBuilder.setPath(remoteStorageInfo.getPath());
        Map<String, String> remoteStorageConf = remoteStorageInfo.getConfItems();
        if (!remoteStorageConf.isEmpty()) {
            RssProtos.RemoteStorageConfItem.Builder rsConfBuilder = RssProtos.RemoteStorageConfItem.newBuilder();
            for (Map.Entry<String, String> entry : remoteStorageConf.entrySet()) {
                rsConfBuilder.setKey(entry.getKey()).setValue(entry.getValue());
                rsBuilder.addRemoteStorageConf(rsConfBuilder.build());
            }
        }
        reqBuilder.setRemoteStorage(rsBuilder.build());
        return this.getBlockingStub().registerShuffle(reqBuilder.build());
    }

    private RssProtos.ShuffleCommitResponse doSendCommit(String appId, int shuffleId) {
        RssProtos.ShuffleCommitRequest request = RssProtos.ShuffleCommitRequest.newBuilder().setAppId(appId).setShuffleId(shuffleId).build();
        int retryNum = 0;
        while (retryNum <= this.maxRetryAttempts) {
            try {
                RssProtos.ShuffleCommitResponse response = this.getBlockingStub().commitShuffleTask(request);
                return response;
            }
            catch (Exception e) {
                LOG.warn("Send commit to host[" + this.host + "], port[" + this.port + "] failed, try again, retryNum[" + ++retryNum + "]", (Throwable)e);
            }
        }
        throw new RssException("Send commit to host[" + this.host + "], port[" + this.port + "] failed");
    }

    private RssProtos.AppHeartBeatResponse doSendHeartBeat(String appId, long timeout) {
        RssProtos.AppHeartBeatRequest request = RssProtos.AppHeartBeatRequest.newBuilder().setAppId(appId).build();
        return ((ShuffleServerGrpc.ShuffleServerBlockingStub)this.blockingStub.withDeadlineAfter(timeout, TimeUnit.MILLISECONDS)).appHeartbeat(request);
    }

    @VisibleForTesting
    public long requirePreAllocation(String appId, int requireSize, int retryMax, long retryIntervalMax) throws Exception {
        return this.requirePreAllocation(appId, 0, Collections.emptyList(), requireSize, retryMax, retryIntervalMax);
    }

    public long requirePreAllocation(String appId, int shuffleId, List<Integer> partitionIds, int requireSize, int retryMax, long retryIntervalMax) {
        RssProtos.RequireBufferRequest rpcRequest = RssProtos.RequireBufferRequest.newBuilder().setShuffleId(shuffleId).addAllPartitionIds(partitionIds).setAppId(appId).setRequireSize(requireSize).build();
        long start = System.currentTimeMillis();
        RssProtos.RequireBufferResponse rpcResponse = this.getBlockingStub().requireBuffer(rpcRequest);
        int retry = 0;
        long result = -1L;
        Random random = new Random();
        int backOffBase = 2000;
        while (rpcResponse.getStatus() == RssProtos.StatusCode.NO_BUFFER) {
            LOG.info("Can't require " + requireSize + " bytes from " + this.host + ":" + this.port + ", sleep and try[" + retry + "] again");
            if (retry >= retryMax) {
                LOG.warn("ShuffleServer " + this.host + ":" + this.port + " is full and can't send shuffle data successfully after retry " + retryMax + " times, cost: {}(ms)", (Object)(System.currentTimeMillis() - start));
                return result;
            }
            try {
                long backoffTime = Math.min(retryIntervalMax, 2000L * (1L << Math.min(retry, 16)) + (long)random.nextInt(2000));
                Thread.sleep(backoffTime);
            }
            catch (Exception e) {
                LOG.warn("Exception happened when require pre allocation from " + this.host + ":" + this.port, (Throwable)e);
            }
            rpcResponse = this.getBlockingStub().requireBuffer(rpcRequest);
            ++retry;
        }
        if (rpcResponse.getStatus() == RssProtos.StatusCode.SUCCESS) {
            LOG.debug("Require preAllocated size of {} from {}:{}, cost: {}(ms)", new Object[]{requireSize, this.host, this.port, System.currentTimeMillis() - start});
            result = rpcResponse.getRequireBufferId();
        } else if (rpcResponse.getStatus() == RssProtos.StatusCode.NO_REGISTER) {
            String msg = "Can't require " + requireSize + " bytes from " + this.host + ":" + this.port + ", statusCode=" + rpcResponse.getStatus() + ", errorMsg:" + rpcResponse.getRetMsg();
            throw new NotRetryException(msg);
        }
        return result;
    }

    private RssProtos.ShuffleUnregisterResponse doUnregisterShuffle(String appId, int shuffleId) {
        RssProtos.ShuffleUnregisterRequest request = RssProtos.ShuffleUnregisterRequest.newBuilder().setAppId(appId).setShuffleId(shuffleId).build();
        return this.blockingStub.unregisterShuffle(request);
    }

    @Override
    public RssUnregisterShuffleResponse unregisterShuffle(RssUnregisterShuffleRequest request) {
        RssUnregisterShuffleResponse response;
        RssProtos.ShuffleUnregisterResponse rpcResponse = this.doUnregisterShuffle(request.getAppId(), request.getShuffleId());
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssUnregisterShuffleResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = String.format("Errors on unregister shuffle to %s:%s for appId[%s].shuffleId[%], error: %s", this.host, this.port, request.getAppId(), request.getShuffleId(), rpcResponse.getRetMsg());
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    @Override
    public RssRegisterShuffleResponse registerShuffle(RssRegisterShuffleRequest request) {
        RssRegisterShuffleResponse response;
        RssProtos.ShuffleRegisterResponse rpcResponse = this.doRegisterShuffle(request.getAppId(), request.getShuffleId(), request.getPartitionRanges(), request.getRemoteStorageInfo(), request.getUser(), request.getDataDistributionType(), request.getMaxConcurrencyPerPartitionToWrite());
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssRegisterShuffleResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = "Can't register shuffle to " + this.host + ":" + this.port + " for appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    @Override
    public RssSendShuffleDataResponse sendShuffleData(RssSendShuffleDataRequest request) {
        String appId = request.getAppId();
        Map<Integer, Map<Integer, List<ShuffleBlockInfo>>> shuffleIdToBlocks = request.getShuffleIdToBlocks();
        boolean isSuccessful = true;
        for (Map.Entry<Integer, Map<Integer, List<ShuffleBlockInfo>>> stb : shuffleIdToBlocks.entrySet()) {
            ArrayList<RssProtos.ShuffleData> shuffleData = Lists.newArrayList();
            int size = 0;
            int blockNum = 0;
            int shuffleId = stb.getKey();
            ArrayList<Integer> partitionIds = new ArrayList<Integer>();
            for (Map.Entry<Integer, List<ShuffleBlockInfo>> ptb : stb.getValue().entrySet()) {
                ArrayList<RssProtos.ShuffleBlock> shuffleBlocks = Lists.newArrayList();
                for (ShuffleBlockInfo sbi : ptb.getValue()) {
                    shuffleBlocks.add(RssProtos.ShuffleBlock.newBuilder().setBlockId(sbi.getBlockId()).setCrc(sbi.getCrc()).setLength(sbi.getLength()).setTaskAttemptId(sbi.getTaskAttemptId()).setUncompressLength(sbi.getUncompressLength()).setData(UnsafeByteOperations.unsafeWrap(sbi.getData().nioBuffer())).build());
                    size += sbi.getSize();
                    ++blockNum;
                }
                shuffleData.add(RssProtos.ShuffleData.newBuilder().setPartitionId(ptb.getKey()).addAllBlock(shuffleBlocks).build());
                partitionIds.add(ptb.getKey());
            }
            int allocateSize = size;
            int finalBlockNum = blockNum;
            try {
                RetryUtils.retry(() -> {
                    long requireId = this.requirePreAllocation(appId, shuffleId, partitionIds, allocateSize, request.getRetryMax() / this.maxRetryAttempts, request.getRetryIntervalMax());
                    if (requireId == -1L) {
                        throw new RssException(String.format("requirePreAllocation failed! size[%s], host[%s], port[%s]", allocateSize, this.host, this.port));
                    }
                    long start = System.currentTimeMillis();
                    RssProtos.SendShuffleDataRequest rpcRequest = RssProtos.SendShuffleDataRequest.newBuilder().setAppId(appId).setShuffleId((Integer)stb.getKey()).setRequireBufferId(requireId).addAllShuffleData(shuffleData).setTimestamp(start).build();
                    RssProtos.SendShuffleDataResponse response = this.getBlockingStub().sendShuffleData(rpcRequest);
                    LOG.debug("Do sendShuffleData to {}:{} rpc cost:" + (System.currentTimeMillis() - start) + " ms for " + allocateSize + " bytes with " + finalBlockNum + " blocks", (Object)this.host, (Object)this.port);
                    if (response.getStatus() != RssProtos.StatusCode.SUCCESS) {
                        String msg = "Can't send shuffle data with " + finalBlockNum + " blocks to " + this.host + ":" + this.port + ", statusCode=" + response.getStatus() + ", errorMsg:" + response.getRetMsg();
                        if (response.getStatus() == RssProtos.StatusCode.NO_REGISTER) {
                            throw new NotRetryException(msg);
                        }
                        throw new RssException(msg);
                    }
                    return response;
                }, request.getRetryIntervalMax(), this.maxRetryAttempts);
            }
            catch (Throwable throwable) {
                LOG.warn(throwable.getMessage());
                isSuccessful = false;
                break;
            }
        }
        RssSendShuffleDataResponse response = isSuccessful ? new RssSendShuffleDataResponse(StatusCode.SUCCESS) : new RssSendShuffleDataResponse(StatusCode.INTERNAL_ERROR);
        return response;
    }

    @Override
    public RssSendCommitResponse sendCommit(RssSendCommitRequest request) {
        RssProtos.ShuffleCommitResponse rpcResponse = this.doSendCommit(request.getAppId(), request.getShuffleId());
        if (rpcResponse.getStatus() != RssProtos.StatusCode.SUCCESS) {
            String msg = "Can't commit shuffle data to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + "], errorMsg:" + rpcResponse.getRetMsg();
            LOG.error(msg);
            throw new RssException(msg);
        }
        RssSendCommitResponse response = new RssSendCommitResponse(StatusCode.SUCCESS);
        response.setCommitCount(rpcResponse.getCommitCount());
        return response;
    }

    @Override
    public RssAppHeartBeatResponse sendHeartBeat(RssAppHeartBeatRequest request) {
        RssProtos.AppHeartBeatResponse appHeartBeatResponse = this.doSendHeartBeat(request.getAppId(), request.getTimeoutMs());
        if (appHeartBeatResponse.getStatus() != RssProtos.StatusCode.SUCCESS) {
            String msg = "Can't send heartbeat to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", timeout=" + request.getTimeoutMs() + "ms], errorMsg:" + appHeartBeatResponse.getRetMsg();
            LOG.error(msg);
            return new RssAppHeartBeatResponse(StatusCode.INTERNAL_ERROR);
        }
        return new RssAppHeartBeatResponse(StatusCode.SUCCESS);
    }

    @Override
    public RssFinishShuffleResponse finishShuffle(RssFinishShuffleRequest request) {
        RssProtos.FinishShuffleRequest rpcRequest = RssProtos.FinishShuffleRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).build();
        long start = System.currentTimeMillis();
        RssProtos.FinishShuffleResponse rpcResponse = this.getBlockingStub().finishShuffle(rpcRequest);
        if (rpcResponse.getStatus() != RssProtos.StatusCode.SUCCESS) {
            String msg = "Can't finish shuffle process to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + "], errorMsg:" + rpcResponse.getRetMsg();
            LOG.error(msg);
            throw new RssException(msg);
        }
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "]";
        LOG.info("FinishShuffle to {}:{} for {} cost {} ms", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start});
        RssFinishShuffleResponse response = new RssFinishShuffleResponse(StatusCode.SUCCESS);
        return response;
    }

    @Override
    public RssReportShuffleResultResponse reportShuffleResult(RssReportShuffleResultRequest request) {
        RssReportShuffleResultResponse response;
        ArrayList<RssProtos.PartitionToBlockIds> partitionToBlockIds = Lists.newArrayList();
        for (Map.Entry<Integer, List<Long>> entry : request.getPartitionToBlockIds().entrySet()) {
            List<Long> blockIds = entry.getValue();
            if (blockIds == null || blockIds.isEmpty()) continue;
            partitionToBlockIds.add(RssProtos.PartitionToBlockIds.newBuilder().setPartitionId(entry.getKey()).addAllBlockIds((Iterable<? extends Long>)entry.getValue()).build());
        }
        RssProtos.ReportShuffleResultRequest recRequest = RssProtos.ReportShuffleResultRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setTaskAttemptId(request.getTaskAttemptId()).setBitmapNum(request.getBitmapNum()).addAllPartitionToBlockIds(partitionToBlockIds).build();
        RssProtos.ReportShuffleResultResponse rpcResponse = this.doReportShuffleResult(recRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssReportShuffleResultResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = "Can't report shuffle result to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    private RssProtos.ReportShuffleResultResponse doReportShuffleResult(RssProtos.ReportShuffleResultRequest rpcRequest) {
        int retryNum = 0;
        while (retryNum < this.maxRetryAttempts) {
            try {
                RssProtos.ReportShuffleResultResponse response = this.getBlockingStub().reportShuffleResult(rpcRequest);
                return response;
            }
            catch (Exception e) {
                LOG.warn("Report shuffle result to host[" + this.host + "], port[" + this.port + "] failed, try again, retryNum[" + ++retryNum + "]", (Throwable)e);
            }
        }
        throw new RssException("Report shuffle result to host[" + this.host + "], port[" + this.port + "] failed");
    }

    @Override
    public RssGetShuffleResultResponse getShuffleResult(RssGetShuffleResultRequest request) {
        RssGetShuffleResultResponse response;
        RssProtos.GetShuffleResultRequest rpcRequest = RssProtos.GetShuffleResultRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).build();
        RssProtos.GetShuffleResultResponse rpcResponse = this.getBlockingStub().getShuffleResult(rpcRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                try {
                    response = new RssGetShuffleResultResponse(StatusCode.SUCCESS, rpcResponse.getSerializedBitmap().toByteArray());
                    break;
                }
                catch (Exception e) {
                    throw new RssException(e);
                }
            }
            default: {
                String msg = "Can't get shuffle result from " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetShuffleResultResponse getShuffleResultForMultiPart(RssGetShuffleResultForMultiPartRequest request) {
        RssGetShuffleResultResponse response;
        RssProtos.GetShuffleResultForMultiPartRequest rpcRequest = RssProtos.GetShuffleResultForMultiPartRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).addAllPartitions(request.getPartitions()).build();
        RssProtos.GetShuffleResultForMultiPartResponse rpcResponse = this.getBlockingStub().getShuffleResultForMultiPart(rpcRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                try {
                    response = new RssGetShuffleResultResponse(StatusCode.SUCCESS, rpcResponse.getSerializedBitmap().toByteArray());
                    break;
                }
                catch (Exception e) {
                    throw new RssException(e);
                }
            }
            default: {
                String msg = "Can't get shuffle result from " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetShuffleDataResponse getShuffleData(RssGetShuffleDataRequest request) {
        RssGetShuffleDataResponse response;
        long start = System.currentTimeMillis();
        RssProtos.GetLocalShuffleDataRequest rpcRequest = RssProtos.GetLocalShuffleDataRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setPartitionNumPerRange(request.getPartitionNumPerRange()).setPartitionNum(request.getPartitionNum()).setOffset(request.getOffset()).setLength(request.getLength()).setTimestamp(start).build();
        RssProtos.GetLocalShuffleDataResponse rpcResponse = this.getBlockingStub().getLocalShuffleData(rpcRequest);
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "]";
        LOG.info("GetShuffleData from {}:{} for {} cost {} ms", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start});
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssGetShuffleDataResponse(StatusCode.SUCCESS, ByteBuffer.wrap(rpcResponse.getData().toByteArray()));
                break;
            }
            default: {
                String msg = "Can't get shuffle data from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetShuffleIndexResponse getShuffleIndex(RssGetShuffleIndexRequest request) {
        RssGetShuffleIndexResponse response;
        RssProtos.GetLocalShuffleIndexRequest rpcRequest = RssProtos.GetLocalShuffleIndexRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setPartitionNumPerRange(request.getPartitionNumPerRange()).setPartitionNum(request.getPartitionNum()).build();
        long start = System.currentTimeMillis();
        RssProtos.GetLocalShuffleIndexResponse rpcResponse = this.getBlockingStub().getLocalShuffleIndex(rpcRequest);
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "]";
        LOG.info("GetShuffleIndex from {}:{} for {} cost {} ms", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start});
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssGetShuffleIndexResponse(StatusCode.SUCCESS, ByteBuffer.wrap(rpcResponse.getIndexData().toByteArray()), rpcResponse.getDataFileLen());
                break;
            }
            default: {
                String msg = "Can't get shuffle index from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetInMemoryShuffleDataResponse getInMemoryShuffleData(RssGetInMemoryShuffleDataRequest request) {
        RssGetInMemoryShuffleDataResponse response;
        long start = System.currentTimeMillis();
        ByteString serializedTaskIdsBytes = ByteString.EMPTY;
        try {
            if (request.getExpectedTaskIds() != null) {
                serializedTaskIdsBytes = UnsafeByteOperations.unsafeWrap(RssUtils.serializeBitMap(request.getExpectedTaskIds()));
            }
        }
        catch (Exception e) {
            throw new RssException("Errors on serializing task ids bitmap.", e);
        }
        RssProtos.GetMemoryShuffleDataRequest rpcRequest = RssProtos.GetMemoryShuffleDataRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setLastBlockId(request.getLastBlockId()).setReadBufferSize(request.getReadBufferSize()).setSerializedExpectedTaskIdsBitmap(serializedTaskIdsBytes).setTimestamp(start).build();
        RssProtos.GetMemoryShuffleDataResponse rpcResponse = this.getBlockingStub().getMemoryShuffleData(rpcRequest);
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "]";
        LOG.info("GetInMemoryShuffleData from {}:{} for " + requestInfo + " cost " + (System.currentTimeMillis() - start) + " ms", (Object)this.host, (Object)this.port);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssGetInMemoryShuffleDataResponse(StatusCode.SUCCESS, ByteBuffer.wrap(rpcResponse.getData().toByteArray()), this.toBufferSegments(rpcResponse.getShuffleDataBlockSegmentsList()));
                break;
            }
            default: {
                String msg = "Can't get shuffle in memory data from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public String getClientInfo() {
        return "ShuffleServerGrpcClient for host[" + this.host + "], port[" + this.port + "]";
    }

    private List<RssProtos.ShufflePartitionRange> toShufflePartitionRanges(List<PartitionRange> partitionRanges) {
        ArrayList<RssProtos.ShufflePartitionRange> ret = Lists.newArrayList();
        for (PartitionRange partitionRange : partitionRanges) {
            ret.add(RssProtos.ShufflePartitionRange.newBuilder().setStart(partitionRange.getStart()).setEnd(partitionRange.getEnd()).build());
        }
        return ret;
    }

    protected List<BufferSegment> toBufferSegments(List<RssProtos.ShuffleDataBlockSegment> blockSegments) {
        ArrayList<BufferSegment> ret = Lists.newArrayList();
        for (RssProtos.ShuffleDataBlockSegment sdbs : blockSegments) {
            ret.add(new BufferSegment(sdbs.getBlockId(), sdbs.getOffset(), sdbs.getLength(), sdbs.getUncompressLength(), sdbs.getCrc(), sdbs.getTaskAttemptId()));
        }
        return ret;
    }

    @VisibleForTesting
    public void adjustTimeout(long timeout) {
        this.rpcTimeout = timeout;
    }
}

