/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.netty.protocol.Decoders;
import org.apache.uniffle.common.netty.protocol.Encoders;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.io.netty.buffer.ByteBuf;
import org.apache.uniffle.io.netty.buffer.Unpooled;

public class GetMemoryShuffleDataResponse
extends RpcResponse {
    private List<BufferSegment> bufferSegments;
    private ByteBuf data;

    public GetMemoryShuffleDataResponse(long requestId, StatusCode statusCode, List<BufferSegment> bufferSegments, byte[] data) {
        this(requestId, statusCode, null, bufferSegments, data);
    }

    public GetMemoryShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, List<BufferSegment> bufferSegments, byte[] data) {
        this(requestId, statusCode, retMessage, bufferSegments, Unpooled.wrappedBuffer(data));
    }

    public GetMemoryShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, List<BufferSegment> bufferSegments, ByteBuf data) {
        super(requestId, statusCode, retMessage);
        this.bufferSegments = bufferSegments;
        this.data = data;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + Encoders.encodeLengthOfBufferSegments(this.bufferSegments) + 4 + this.data.readableBytes();
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        Encoders.encodeBufferSegments(this.bufferSegments, buf);
        ByteBufUtils.copyByteBuf(this.data, buf);
        this.data.release();
    }

    public static GetMemoryShuffleDataResponse decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        List<BufferSegment> bufferSegments = Decoders.decodeBufferSegments(byteBuf);
        ByteBuf data = ByteBufUtils.readSlice(byteBuf);
        return new GetMemoryShuffleDataResponse(requestId, statusCode, retMessage, bufferSegments, data);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_MEMORY_SHUFFLE_DATA_RESPONSE;
    }

    public List<BufferSegment> getBufferSegments() {
        return this.bufferSegments;
    }

    public ByteBuf getData() {
        return this.data;
    }
}

