/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.storage.StorageInfo;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.server.Checker;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.event.AppPurgeEvent;
import org.apache.uniffle.server.event.PurgeEvent;
import org.apache.uniffle.server.storage.SingleStorageManager;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.collect.Maps;
import org.apache.uniffle.storage.common.HadoopStorage;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.factory.ShuffleHandlerFactory;
import org.apache.uniffle.storage.handler.api.ShuffleDeleteHandler;
import org.apache.uniffle.storage.request.CreateShuffleDeleteHandlerRequest;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStorageManager
extends SingleStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStorageManager.class);
    private final Configuration hadoopConf;
    private final String shuffleServerId;
    private Map<String, HadoopStorage> appIdToStorages = JavaUtils.newConcurrentMap();
    private Map<String, HadoopStorage> pathToStorages = JavaUtils.newConcurrentMap();

    HadoopStorageManager(ShuffleServerConf conf) {
        super(conf);
        this.hadoopConf = conf.getHadoopConf();
        this.shuffleServerId = conf.getString("rss.server.id", "shuffleServerId");
    }

    @Override
    public void updateWriteMetrics(ShuffleDataFlushEvent event, long writeTime) {
        super.updateWriteMetrics(event, writeTime);
        Storage storage = event.getUnderStorage();
        if (storage == null) {
            LOG.warn("The storage owned by event: {} is null, this should not happen", (Object)event);
            return;
        }
        ShuffleServerMetrics.incHadoopStorageWriteDataSize(storage.getStorageHost(), event.getSize(), event.isOwnedByHugePartition());
    }

    @Override
    public Storage selectStorage(ShuffleDataFlushEvent event) {
        HadoopStorage storage = this.getStorageByAppId(event.getAppId());
        event.setUnderStorage((Storage)storage);
        return storage;
    }

    @Override
    public Storage selectStorage(ShuffleDataReadEvent event) {
        return this.getStorageByAppId(event.getAppId());
    }

    @Override
    public void removeResources(PurgeEvent event) {
        String appId = event.getAppId();
        HadoopStorage storage = this.getStorageByAppId(appId);
        if (storage != null) {
            boolean purgeForExpired = false;
            if (event instanceof AppPurgeEvent) {
                storage.removeHandlers(appId);
                this.appIdToStorages.remove(appId);
                purgeForExpired = ((AppPurgeEvent)event).isAppExpired();
            }
            ShuffleDeleteHandler deleteHandler = ShuffleHandlerFactory.getInstance().createShuffleDeleteHandler(new CreateShuffleDeleteHandlerRequest(StorageType.HDFS.name(), storage.getConf(), purgeForExpired ? this.shuffleServerId : null));
            String basicPath = ShuffleStorageUtils.getFullShuffleDataFolder((String)storage.getStoragePath(), (String)appId);
            ArrayList<String> deletePaths = new ArrayList<String>();
            if (event instanceof AppPurgeEvent) {
                deletePaths.add(basicPath);
            } else {
                for (Integer shuffleId : event.getShuffleIds()) {
                    deletePaths.add(ShuffleStorageUtils.getFullShuffleDataFolder((String)basicPath, (String)String.valueOf(shuffleId)));
                }
            }
            deleteHandler.delete(deletePaths.toArray(new String[0]), appId, event.getUser());
        } else {
            LOG.warn("Storage gotten is null when removing resources for event: {}", (Object)event);
        }
    }

    @Override
    public Checker getStorageChecker() {
        throw new RssException("Not support storage checker");
    }

    @Override
    public void registerRemoteStorage(String appId, RemoteStorageInfo remoteStorageInfo) {
        String remoteStorage = remoteStorageInfo.getPath();
        this.pathToStorages.computeIfAbsent(remoteStorage, key -> {
            Map remoteStorageConf = remoteStorageInfo.getConfItems();
            Configuration remoteStorageHadoopConf = new Configuration(this.hadoopConf);
            if (remoteStorageConf != null && remoteStorageConf.size() > 0) {
                for (Map.Entry entry : remoteStorageConf.entrySet()) {
                    remoteStorageHadoopConf.setStrings((String)entry.getKey(), new String[]{(String)entry.getValue()});
                }
            }
            HadoopStorage hadoopStorage = new HadoopStorage(remoteStorage, remoteStorageHadoopConf);
            return hadoopStorage;
        });
        this.appIdToStorages.computeIfAbsent(appId, key -> this.pathToStorages.get(remoteStorage));
        LOG.info("register remote storage {} successfully for appId {}", (Object)remoteStorageInfo, (Object)appId);
    }

    @Override
    public void checkAndClearLeakedShuffleData(Collection<String> appIds) {
    }

    @Override
    public Map<String, StorageInfo> getStorageInfo() {
        return Maps.newHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HadoopStorage getStorageByAppId(String appId) {
        if (!this.appIdToStorages.containsKey(appId)) {
            HadoopStorageManager hadoopStorageManager = this;
            synchronized (hadoopStorageManager) {
                try {
                    List appStoragePath = this.pathToStorages.keySet().stream().map(basePath -> new Path(basePath + "/" + appId)).collect(Collectors.toList());
                    for (Path path : appStoragePath) {
                        FileSystem fs = HadoopFilesystemProvider.getFilesystem((Path)path, (Configuration)this.hadoopConf);
                        if (!fs.isDirectory(path)) continue;
                        return new HadoopStorage(path.getParent().toString(), this.hadoopConf);
                    }
                }
                catch (Exception e) {
                    LOG.error("Some error happened when fileSystem got the file status.", (Throwable)e);
                }
                return null;
            }
        }
        return this.appIdToStorages.get(appId);
    }

    @VisibleForTesting
    public Map<String, HadoopStorage> getAppIdToStorages() {
        return this.appIdToStorages;
    }

    @VisibleForTesting
    public Map<String, HadoopStorage> getPathToStorages() {
        return this.pathToStorages;
    }
}

