/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.storage.common.AbstractStorage;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.common.StorageWriteMetrics;
import org.apache.uniffle.storage.handler.api.ServerReadHandler;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.HadoopShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.PooledHadoopShuffleWriteHandler;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.request.CreateShuffleWriteHandlerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStorage
extends AbstractStorage {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStorage.class);
    private final String storagePath;
    private final Configuration conf;
    private String storageHost;

    public HadoopStorage(String path, Configuration conf) {
        this.storagePath = path;
        this.conf = conf;
        try {
            URI uri = new URI(path);
            this.storageHost = uri.getHost();
        }
        catch (URISyntaxException e) {
            this.storageHost = "";
            LOG.warn("Invalid format of remoteStoragePath to get storage host, {}", (Object)path);
        }
    }

    @Override
    public String getStoragePath() {
        return this.storagePath;
    }

    @Override
    public String getStorageHost() {
        return this.storageHost;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void updateReadMetrics(StorageReadMetrics metrics) {
    }

    @Override
    public void updateWriteMetrics(StorageWriteMetrics metrics) {
    }

    @Override
    ShuffleWriteHandler newWriteHandler(CreateShuffleWriteHandlerRequest request) {
        try {
            String user = request.getUser();
            if (request.getMaxFileNumber() == 1) {
                return new HadoopShuffleWriteHandler(request.getAppId(), request.getShuffleId(), request.getStartPartition(), request.getEndPartition(), this.storagePath, request.getFileNamePrefix(), this.conf, user);
            }
            return new PooledHadoopShuffleWriteHandler(request.getAppId(), request.getShuffleId(), request.getStartPartition(), request.getEndPartition(), this.storagePath, request.getFileNamePrefix(), this.conf, user, request.getMaxFileNumber());
        }
        catch (Exception e) {
            throw new RssException((Throwable)e);
        }
    }

    @Override
    protected ServerReadHandler newReadHandler(CreateShuffleReadHandlerRequest request) {
        throw new RssException("Hadoop FS storage don't support to read from sever");
    }

    @Override
    public void createMetadataIfNotExist(String shuffleKey) {
    }

    public Configuration getConf() {
        return this.conf;
    }
}

