/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.metric;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.metrics.MetricsManager;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.collect.Maps;

public class CoordinatorMetrics {
    private static final String TOTAL_SERVER_NUM = "total_server_num";
    private static final String RUNNING_APP_NUM = "running_app_num";
    private static final String TOTAL_APP_NUM = "total_app_num";
    private static final String EXCLUDE_SERVER_NUM = "exclude_server_num";
    private static final String UNHEALTHY_SERVER_NUM = "unhealthy_server_num";
    private static final String TOTAL_ACCESS_REQUEST = "total_access_request";
    private static final String TOTAL_CANDIDATES_DENIED_REQUEST = "total_candidates_denied_request";
    private static final String TOTAL_LOAD_DENIED_REQUEST = "total_load_denied_request";
    private static final String TOTAL_QUOTA_DENIED_REQUEST = "total_quota_denied_request";
    public static final String REMOTE_STORAGE_IN_USED_PREFIX = "remote_storage_in_used_";
    public static final String APP_NUM_TO_USER = "app_num";
    public static final String USER_LABEL = "user_name";
    public static Gauge gaugeTotalServerNum;
    public static Gauge gaugeExcludeServerNum;
    public static Gauge gaugeUnhealthyServerNum;
    public static Gauge gaugeRunningAppNum;
    public static Gauge gaugeRunningAppNumToUser;
    public static Counter counterTotalAppNum;
    public static Counter counterTotalAccessRequest;
    public static Counter counterTotalCandidatesDeniedRequest;
    public static Counter counterTotalQuotaDeniedRequest;
    public static Counter counterTotalLoadDeniedRequest;
    public static final Map<String, Gauge> GAUGE_USED_REMOTE_STORAGE;
    private static MetricsManager metricsManager;
    private static boolean isRegister;

    public static synchronized void register(CollectorRegistry collectorRegistry) {
        if (!isRegister) {
            HashMap<String, String> labels = Maps.newHashMap();
            labels.put("tags", "coordinator");
            metricsManager = new MetricsManager(collectorRegistry, labels);
            isRegister = true;
            CoordinatorMetrics.setUpMetrics();
        }
    }

    @VisibleForTesting
    public static void register() {
        CoordinatorMetrics.register(CollectorRegistry.defaultRegistry);
    }

    @VisibleForTesting
    public static void clear() {
        isRegister = false;
        GAUGE_USED_REMOTE_STORAGE.clear();
        CollectorRegistry.defaultRegistry.clear();
    }

    public static CollectorRegistry getCollectorRegistry() {
        return metricsManager.getCollectorRegistry();
    }

    public static void addDynamicGaugeForRemoteStorage(String storageHost) {
        if (!StringUtils.isEmpty((CharSequence)storageHost) && !GAUGE_USED_REMOTE_STORAGE.containsKey(storageHost)) {
            String metricName = REMOTE_STORAGE_IN_USED_PREFIX + RssUtils.getMetricNameForHostName((String)storageHost);
            GAUGE_USED_REMOTE_STORAGE.putIfAbsent(storageHost, metricsManager.addGauge(metricName, new String[0]));
        }
    }

    public static void updateDynamicGaugeForRemoteStorage(String storageHost, double value) {
        if (GAUGE_USED_REMOTE_STORAGE.containsKey(storageHost)) {
            GAUGE_USED_REMOTE_STORAGE.get(storageHost).set(value);
        }
    }

    private static void setUpMetrics() {
        gaugeTotalServerNum = metricsManager.addGauge(TOTAL_SERVER_NUM, new String[0]);
        gaugeExcludeServerNum = metricsManager.addGauge(EXCLUDE_SERVER_NUM, new String[0]);
        gaugeUnhealthyServerNum = metricsManager.addGauge(UNHEALTHY_SERVER_NUM, new String[0]);
        gaugeRunningAppNum = metricsManager.addGauge(RUNNING_APP_NUM, new String[0]);
        gaugeRunningAppNumToUser = metricsManager.addGauge(APP_NUM_TO_USER, new String[]{USER_LABEL});
        counterTotalAppNum = metricsManager.addCounter(TOTAL_APP_NUM, new String[0]);
        counterTotalAccessRequest = metricsManager.addCounter(TOTAL_ACCESS_REQUEST, new String[0]);
        counterTotalCandidatesDeniedRequest = metricsManager.addCounter(TOTAL_CANDIDATES_DENIED_REQUEST, new String[0]);
        counterTotalQuotaDeniedRequest = metricsManager.addCounter(TOTAL_QUOTA_DENIED_REQUEST, new String[0]);
        counterTotalLoadDeniedRequest = metricsManager.addCounter(TOTAL_LOAD_DENIED_REQUEST, new String[0]);
    }

    static {
        GAUGE_USED_REMOTE_STORAGE = JavaUtils.newConcurrentMap();
        isRegister = false;
    }
}

