/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.uniffle.storage.api.FileWriter;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileWriter
implements FileWriter,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFileWriter.class);
    private final FileSystem fileSystem;
    private Path path;
    private Configuration hadoopConf;
    private FSDataOutputStream fsDataOutputStream;
    private long nextOffset;

    public HadoopFileWriter(FileSystem fileSystem, Path path, Configuration hadoopConf) throws IOException {
        this.path = path;
        this.hadoopConf = hadoopConf;
        this.fileSystem = fileSystem;
        this.initStream();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initStream() throws IOException, IllegalStateException {
        FileSystem writerFs = this.fileSystem;
        if (writerFs.isFile(this.path)) {
            if (this.hadoopConf.getBoolean("dfs.support.append", true)) {
                this.fsDataOutputStream = writerFs.append(this.path);
                this.nextOffset = this.fsDataOutputStream.getPos();
                return;
            }
            String msg = this.path + " exists but append mode is not support!";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        if (writerFs.isDirectory(this.path)) {
            String msg = this.path + " is a directory!";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        this.fsDataOutputStream = writerFs.create(this.path);
        this.nextOffset = this.fsDataOutputStream.getPos();
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            this.fsDataOutputStream.write(data);
            this.nextOffset = this.fsDataOutputStream.getPos();
        }
    }

    public void writeData(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasArray()) {
            this.fsDataOutputStream.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] byteArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byteArray);
            this.fsDataOutputStream.write(byteArray);
        }
        this.nextOffset = this.fsDataOutputStream.getPos();
    }

    @Override
    public void writeIndex(FileBasedShuffleSegment segment) throws IOException {
        this.fsDataOutputStream.writeLong(segment.getOffset());
        this.fsDataOutputStream.writeInt(segment.getLength());
        this.fsDataOutputStream.writeInt(segment.getUncompressLength());
        this.fsDataOutputStream.writeLong(segment.getCrc());
        this.fsDataOutputStream.writeLong(segment.getBlockId());
        this.fsDataOutputStream.writeLong(segment.getTaskAttemptId());
    }

    public long nextOffset() {
        return this.nextOffset;
    }

    public void flush() throws IOException {
        if (this.fsDataOutputStream != null) {
            this.fsDataOutputStream.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fsDataOutputStream != null) {
            this.fsDataOutputStream.close();
        }
    }

    public long copy(FileInputStream inputStream, int bufferSize) throws IOException {
        long start = this.fsDataOutputStream.getPos();
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)this.fsDataOutputStream, (int)bufferSize);
        return this.fsDataOutputStream.getPos() - start;
    }
}

