/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import org.apache.hadoop.util.NodeHealthScriptRunner;
import org.apache.hadoop.util.Shell;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.server.Checker;
import org.apache.uniffle.server.ShuffleServerConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthScriptChecker
extends Checker {
    private static final Logger LOG = LoggerFactory.getLogger(HealthScriptChecker.class);
    private String healthScriptPath;
    private static final String ERROR_PATTERN = "ERROR";
    private long scriptTimeout;

    HealthScriptChecker(ShuffleServerConf conf) {
        super(conf);
        this.healthScriptPath = conf.getString(ShuffleServerConf.HEALTH_CHECKER_SCRIPT_PATH);
        if (!NodeHealthScriptRunner.shouldRun((String)this.healthScriptPath)) {
            LOG.error("Rss health check script:" + this.healthScriptPath + " is not available or doesn't have execute permission, so abort server.");
            throw new RssException("Health script not available.");
        }
        this.scriptTimeout = conf.getLong(ShuffleServerConf.HEALTH_CHECKER_SCRIPT_EXECUTE_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkIsHealthy() {
        HealthCheckerExitStatus status = HealthCheckerExitStatus.SUCCESS;
        Shell.ShellCommandExecutor commandExecutor = new Shell.ShellCommandExecutor(new String[]{this.healthScriptPath}, null, null, this.scriptTimeout);
        try {
            commandExecutor.execute();
        }
        catch (Shell.ExitCodeException e) {
            status = HealthCheckerExitStatus.FAILED_WITH_EXIT_CODE;
            if (Shell.WINDOWS && commandExecutor.isTimedOut()) {
                status = HealthCheckerExitStatus.TIMED_OUT;
            }
        }
        catch (Exception e) {
            LOG.warn("execute health script exception, please check script.", (Throwable)e);
            status = !commandExecutor.isTimedOut() ? HealthCheckerExitStatus.FAILED_WITH_EXCEPTION : HealthCheckerExitStatus.TIMED_OUT;
        }
        finally {
            if (status == HealthCheckerExitStatus.SUCCESS && this.hasErrors(commandExecutor.getOutput())) {
                status = HealthCheckerExitStatus.FAILED;
            }
        }
        if (status != HealthCheckerExitStatus.SUCCESS) {
            LOG.warn("health script check failed. exit status : " + (Object)((Object)status));
        }
        return status == HealthCheckerExitStatus.SUCCESS;
    }

    private boolean hasErrors(String output) {
        String[] splits;
        for (String split : splits = output.split("\n")) {
            if (!split.startsWith(ERROR_PATTERN)) continue;
            return true;
        }
        return false;
    }

    private static enum HealthCheckerExitStatus {
        SUCCESS,
        TIMED_OUT,
        FAILED_WITH_EXIT_CODE,
        FAILED_WITH_EXCEPTION,
        FAILED;

    }
}

