/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleSpecification;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleTaskInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleTaskInfo.class);
    private final String appId;
    private Long currentTimes;
    private Map<Integer, AtomicInteger> commitCounts;
    private Map<Integer, Object> commitLocks;
    private Map<Integer, Roaring64NavigableMap> cachedBlockIds;
    private AtomicReference<String> user;
    private final AtomicLong totalDataSize = new AtomicLong(0L);
    private final AtomicLong inMemoryDataSize = new AtomicLong(0L);
    private final AtomicLong onLocalFileDataSize = new AtomicLong(0L);
    private final AtomicLong onHadoopDataSize = new AtomicLong(0L);
    private Map<Integer, Map<Integer, Long>> partitionDataSizes;
    private final Map<Integer, Set<Integer>> hugePartitionTags;
    private final AtomicBoolean existHugePartition;
    private final AtomicReference<ShuffleSpecification> specification;

    public ShuffleTaskInfo(String appId) {
        this.appId = appId;
        this.currentTimes = System.currentTimeMillis();
        this.commitCounts = JavaUtils.newConcurrentMap();
        this.commitLocks = JavaUtils.newConcurrentMap();
        this.cachedBlockIds = JavaUtils.newConcurrentMap();
        this.user = new AtomicReference();
        this.partitionDataSizes = JavaUtils.newConcurrentMap();
        this.hugePartitionTags = JavaUtils.newConcurrentMap();
        this.existHugePartition = new AtomicBoolean(false);
        this.specification = new AtomicReference();
    }

    public Long getCurrentTimes() {
        return this.currentTimes;
    }

    public void setCurrentTimes(Long currentTimes) {
        this.currentTimes = currentTimes;
    }

    public Map<Integer, AtomicInteger> getCommitCounts() {
        return this.commitCounts;
    }

    public Map<Integer, Object> getCommitLocks() {
        return this.commitLocks;
    }

    public Map<Integer, Roaring64NavigableMap> getCachedBlockIds() {
        return this.cachedBlockIds;
    }

    public String getUser() {
        return this.user.get();
    }

    public void setUser(String user) {
        this.user.set(user);
    }

    public int getMaxConcurrencyPerPartitionToWrite() {
        return this.specification.get().getMaxConcurrencyPerPartitionToWrite();
    }

    public ShuffleDataDistributionType getDataDistType() {
        return this.specification.get().getDistributionType();
    }

    public void setSpecification(ShuffleSpecification specification) {
        this.specification.set(specification);
    }

    public long addPartitionDataSize(int shuffleId, int partitionId, long delta) {
        this.totalDataSize.addAndGet(delta);
        this.inMemoryDataSize.addAndGet(delta);
        this.partitionDataSizes.computeIfAbsent(shuffleId, key -> JavaUtils.newConcurrentMap());
        Map<Integer, Long> partitions = this.partitionDataSizes.get(shuffleId);
        partitions.putIfAbsent(partitionId, 0L);
        return partitions.computeIfPresent(partitionId, (k, v) -> v + delta);
    }

    public long getTotalDataSize() {
        return this.totalDataSize.get();
    }

    public long getInMemoryDataSize() {
        return this.inMemoryDataSize.get();
    }

    public long addOnLocalFileDataSize(long delta) {
        this.inMemoryDataSize.addAndGet(-delta);
        return this.onLocalFileDataSize.addAndGet(delta);
    }

    public long getOnLocalFileDataSize() {
        return this.onLocalFileDataSize.get();
    }

    public long addOnHadoopDataSize(long delta) {
        this.inMemoryDataSize.addAndGet(-delta);
        return this.onHadoopDataSize.addAndGet(delta);
    }

    public long getOnHadoopDataSize() {
        return this.onHadoopDataSize.get();
    }

    public long getPartitionDataSize(int shuffleId, int partitionId) {
        Map<Integer, Long> partitions = this.partitionDataSizes.get(shuffleId);
        if (partitions == null) {
            return 0L;
        }
        Long size = partitions.get(partitionId);
        if (size == null) {
            return 0L;
        }
        return size;
    }

    public boolean hasHugePartition() {
        return this.existHugePartition.get();
    }

    public int getHugePartitionSize() {
        return this.hugePartitionTags.values().stream().map(x -> x.size()).reduce((x, y) -> x + y).orElse(0);
    }

    public void markHugePartition(int shuffleId, int partitionId) {
        Set partitions;
        boolean markedWithCAS;
        if (!this.existHugePartition.get() && (markedWithCAS = this.existHugePartition.compareAndSet(false, true))) {
            ShuffleServerMetrics.gaugeAppWithHugePartitionNum.inc();
            ShuffleServerMetrics.counterTotalAppWithHugePartitionNum.inc();
        }
        if ((partitions = this.hugePartitionTags.computeIfAbsent(shuffleId, key -> Sets.newConcurrentHashSet())).add(partitionId)) {
            ShuffleServerMetrics.counterTotalHugePartitionNum.inc();
            ShuffleServerMetrics.gaugeHugePartitionNum.inc();
            LOGGER.warn("Huge partition occurs, appId: {}, shuffleId: {}, partitionId: {}", new Object[]{this.appId, shuffleId, partitionId});
        }
    }

    public Set<Integer> getShuffleIds() {
        return this.partitionDataSizes.keySet();
    }

    public String toString() {
        return "ShuffleTaskInfo{appId='" + this.appId + '\'' + ", totalDataSize=" + this.totalDataSize + ", inMemoryDataSize=" + this.inMemoryDataSize + ", onLocalFileDataSize=" + this.onLocalFileDataSize + ", onHadoopDataSize=" + this.onHadoopDataSize + ", partitionDataSizes=" + this.partitionDataSizes + '}';
    }
}

