/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.ClientInterceptor;
import io.grpc.Internal;
import io.grpc.ServerInterceptor;
import io.grpc.ServerStreamTracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uniffle.shaded.com.google.common.base.Preconditions;

@Internal
final class GlobalInterceptors {
    private static List<ClientInterceptor> clientInterceptors = null;
    private static List<ServerInterceptor> serverInterceptors = null;
    private static List<ServerStreamTracer.Factory> serverStreamTracerFactories = null;
    private static boolean isGlobalInterceptorsTracersSet;
    private static boolean isGlobalInterceptorsTracersGet;

    private GlobalInterceptors() {
    }

    static synchronized void setInterceptorsTracers(List<ClientInterceptor> clientInterceptorList, List<ServerInterceptor> serverInterceptorList, List<ServerStreamTracer.Factory> serverStreamTracerFactoryList) {
        if (isGlobalInterceptorsTracersGet) {
            throw new IllegalStateException("Set cannot be called after any get call");
        }
        if (isGlobalInterceptorsTracersSet) {
            throw new IllegalStateException("Global interceptors and tracers are already set");
        }
        Preconditions.checkNotNull(clientInterceptorList);
        Preconditions.checkNotNull(serverInterceptorList);
        Preconditions.checkNotNull(serverStreamTracerFactoryList);
        clientInterceptors = Collections.unmodifiableList(new ArrayList<ClientInterceptor>(clientInterceptorList));
        serverInterceptors = Collections.unmodifiableList(new ArrayList<ServerInterceptor>(serverInterceptorList));
        serverStreamTracerFactories = Collections.unmodifiableList(new ArrayList<ServerStreamTracer.Factory>(serverStreamTracerFactoryList));
        isGlobalInterceptorsTracersSet = true;
    }

    static synchronized List<ClientInterceptor> getClientInterceptors() {
        isGlobalInterceptorsTracersGet = true;
        return clientInterceptors;
    }

    static synchronized List<ServerInterceptor> getServerInterceptors() {
        isGlobalInterceptorsTracersGet = true;
        return serverInterceptors;
    }

    static synchronized List<ServerStreamTracer.Factory> getServerStreamTracerFactories() {
        isGlobalInterceptorsTracersGet = true;
        return serverStreamTracerFactories;
    }
}

