/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.config;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.uniffle.common.config.ConfigOption;
import org.apache.uniffle.common.config.ConfigUtils;
import org.apache.uniffle.common.config.FallbackKey;
import org.apache.uniffle.common.util.UnitConverter;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;

public class RssConf
implements Cloneable {
    private ConcurrentHashMap<String, Object> settings;

    public RssConf() {
        this.settings = new ConcurrentHashMap();
    }

    public RssConf(RssConf other) {
        this.settings = new ConcurrentHashMap<String, Object>(other.settings);
    }

    public Set<String> getKeySet() {
        if (this.settings != null) {
            return this.settings.keySet();
        }
        return Sets.newHashSet();
    }

    public String getString(String key, String defaultValue) {
        return this.getRawValue(key).map(ConfigUtils::convertToString).orElse(defaultValue);
    }

    public String getString(ConfigOption<String> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public String getString(ConfigOption<String> configOption, String overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setString(String key, String value) {
        this.setValueInternal(key, value);
    }

    public void setString(ConfigOption<String> key, String value) {
        this.setValueInternal(key.key(), value);
    }

    public int getInteger(String key, int defaultValue) {
        return this.getRawValue(key).map(ConfigUtils::convertToInt).orElse(defaultValue);
    }

    public int getInteger(ConfigOption<Integer> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public int getInteger(ConfigOption<Integer> configOption, int overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setInteger(String key, int value) {
        this.setValueInternal(key, value);
    }

    public void setInteger(ConfigOption<Integer> key, int value) {
        this.setValueInternal(key.key(), value);
    }

    public long getLong(String key, long defaultValue) {
        return this.getRawValue(key).map(ConfigUtils::convertToLong).orElse(defaultValue);
    }

    public long getLong(ConfigOption<Long> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public long getLong(ConfigOption<Long> configOption, long overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setLong(String key, long value) {
        this.setValueInternal(key, value);
    }

    public void setLong(ConfigOption<Long> key, long value) {
        this.setValueInternal(key.key(), value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getRawValue(key).map(ConfigUtils::convertToBoolean).orElse(defaultValue);
    }

    public boolean getBoolean(ConfigOption<Boolean> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public boolean getBoolean(ConfigOption<Boolean> configOption, boolean overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setBoolean(String key, boolean value) {
        this.setValueInternal(key, value);
    }

    public void setBoolean(ConfigOption<Boolean> key, boolean value) {
        this.setValueInternal(key.key(), value);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getRawValue(key).map(ConfigUtils::convertToFloat).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    public float getFloat(ConfigOption<Float> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue).floatValue();
    }

    public float getFloat(ConfigOption<Float> configOption, float overrideDefault) {
        return this.getOptional(configOption).orElse(Float.valueOf(overrideDefault)).floatValue();
    }

    public void setFloat(String key, float value) {
        this.setValueInternal(key, Float.valueOf(value));
    }

    public void setFloat(ConfigOption<Float> key, float value) {
        this.setValueInternal(key.key(), Float.valueOf(value));
    }

    public double getDouble(String key, double defaultValue) {
        return this.getRawValue(key).map(ConfigUtils::convertToDouble).orElse(defaultValue);
    }

    public double getDouble(ConfigOption<Double> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public double getDouble(ConfigOption<Double> configOption, double overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setDouble(String key, double value) {
        this.setValueInternal(key, value);
    }

    public void setDouble(ConfigOption<Double> key, double value) {
        this.setValueInternal(key.key(), value);
    }

    public long getSizeInBytes(String key, long defaultValue) {
        return this.getRawValue(key).map(ConfigUtils::convertToSizeInBytes).orElse(defaultValue);
    }

    public long getSizeAsBytes(String key, String defaultValue) {
        return this.getSizeInBytes(key, UnitConverter.byteStringAsBytes(defaultValue));
    }

    public long getSizeAsBytes(ConfigOption<Long> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    public void setSizeAsBytes(String key, long value) {
        this.setValueInternal(key, value);
    }

    public void setSizeAsBytes(ConfigOption<Long> key, long value) {
        this.setValueInternal(key.key(), value);
    }

    public void setSizeAsBytes(ConfigOption<Long> key, String value) {
        this.setValueInternal(key.key(), UnitConverter.byteStringAsBytes(value));
    }

    public byte[] getBytes(String key, byte[] defaultValue) {
        return this.getRawValue(key).map(o -> {
            if (o.getClass().equals(byte[].class)) {
                return (byte[])o;
            }
            throw new IllegalArgumentException(String.format("Configuration cannot evaluate value %s as a byte[] value", o));
        }).orElse(defaultValue);
    }

    public void setBytes(String key, byte[] bytes) {
        this.setValueInternal(key, bytes);
    }

    public String getValue(ConfigOption<?> configOption) {
        return Optional.ofNullable(this.getRawValueFromOption(configOption).orElseGet(configOption::defaultValue)).map(String::valueOf).orElse(null);
    }

    public RssConf clone() throws CloneNotSupportedException {
        RssConf config = (RssConf)super.clone();
        config.settings = new ConcurrentHashMap<String, Object>(this.settings);
        return config;
    }

    public void addAll(RssConf other) {
        this.settings.putAll(other.settings);
    }

    public boolean containsKey(String key) {
        return this.settings.containsKey(key);
    }

    public boolean contains(ConfigOption<?> configOption) {
        return this.settings.containsKey(configOption.key());
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    private Optional<Object> geRawValFromFallbackKeys(Iterator<FallbackKey> iter) {
        if (iter.hasNext()) {
            FallbackKey key = iter.next();
            Optional<Object> rawVal = this.getRawValue(key.getKey());
            if (!rawVal.isPresent()) {
                return this.geRawValFromFallbackKeys(iter);
            }
            return rawVal;
        }
        return Optional.empty();
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional<Object> rawValue = this.getRawValueFromOption(option);
        if (!rawValue.isPresent()) {
            rawValue = this.geRawValFromFallbackKeys(option.fallbackKeys().iterator());
        }
        Class<?> clazz = option.getClazz();
        Optional<Object> value = rawValue.map(v -> option.convertValue(v, clazz));
        return value;
    }

    public <T> RssConf set(ConfigOption<T> option, T value) {
        this.setValueInternal(option.key(), value);
        return this;
    }

    <T> void setValueInternal(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        this.settings.put(key, value);
    }

    private Optional<Object> getRawValue(String key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        return Optional.ofNullable(this.settings.get(key));
    }

    private Optional<Object> getRawValueFromOption(ConfigOption<?> configOption) {
        return this.getRawValue(configOption.key());
    }

    public boolean loadConf(Map<String, String> properties, List<ConfigOption<Object>> configOptions, boolean includeMissingKey) {
        if (properties == null || configOptions == null) {
            return false;
        }
        Map<String, ConfigOption> configOptionMap = configOptions.stream().collect(Collectors.toMap(c -> c.key().toLowerCase(), c -> c));
        properties.forEach((k, v) -> {
            ConfigOption config = (ConfigOption)configOptionMap.get(k.toLowerCase());
            if (config == null) {
                if (includeMissingKey) {
                    this.setString((String)k, (String)v);
                }
            } else {
                this.set(config, ConfigUtils.convertValue(v, config.getClazz()));
            }
        });
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (String s : this.settings.keySet()) {
            hash ^= s.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RssConf) {
            ConcurrentHashMap<String, Object> otherConf = ((RssConf)obj).settings;
            for (Map.Entry<String, Object> e : this.settings.entrySet()) {
                Object thisVal = e.getValue();
                Object otherVal = otherConf.get(e.getKey());
                if (!thisVal.getClass().equals(byte[].class)) {
                    if (thisVal.equals(otherVal)) continue;
                    return false;
                }
                if (otherVal.getClass().equals(byte[].class)) {
                    if (Arrays.equals((byte[])thisVal, (byte[])otherVal)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.settings.toString();
    }

    public Set<Map.Entry<String, Object>> getAll() {
        return this.settings.entrySet();
    }

    public String getEnv(String key) {
        return System.getenv(key);
    }

    @VisibleForTesting
    public void remove(String key) {
        this.settings.remove(key);
    }
}

