/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.client.RestClient;
import org.apache.uniffle.client.UniffleRestClient;
import org.apache.uniffle.common.Application;
import org.apache.uniffle.entity.ApplicationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(AdminRestApi.class);
    private UniffleRestClient client;

    private AdminRestApi() {
    }

    public AdminRestApi(UniffleRestClient client) {
        this.client = client;
    }

    public String refreshAccessChecker() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.getClient().get("/api/admin/refreshChecker", params, null);
    }

    public List<Application> getApplications(String applications, String applicationIdRegex, String pageSize, String currentPage, String heartBeatTimeRange) throws JsonProcessingException {
        ObjectMapper objectMapper;
        ApplicationResponse response;
        ArrayList<Application> results = new ArrayList<Application>();
        String postJson = this.getApplicationsJson(applications, applicationIdRegex, pageSize, currentPage, heartBeatTimeRange);
        if (StringUtils.isNotBlank((CharSequence)postJson) && (response = (ApplicationResponse)(objectMapper = new ObjectMapper()).readValue(postJson, (TypeReference)new TypeReference<ApplicationResponse>(){})) != null && response.getData() != null) {
            results.addAll(response.getData());
        }
        return results;
    }

    public String getApplicationsJson(String applications, String applicationIdRegex, String pageSize, String currentPage, String heartBeatTimeRange) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)applications)) {
            String[] applicationArrays = applications.split(",");
            params.put("applications", applicationArrays);
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIdRegex)) {
            params.put("appIdRegex", applicationIdRegex);
        }
        if (StringUtils.isNotBlank((CharSequence)pageSize)) {
            params.put("pageSize", Integer.valueOf(pageSize));
        }
        if (StringUtils.isNotBlank((CharSequence)currentPage)) {
            params.put("currentPage", Integer.valueOf(currentPage));
        }
        if (StringUtils.isNotBlank((CharSequence)heartBeatTimeRange)) {
            this.transform(heartBeatTimeRange, params);
        }
        return this.getClient().post("/api/server/applications", params, null);
    }

    private void transform(String heartBeatTimeRange, Map<String, Object> params) {
        String[] timeRange = heartBeatTimeRange.split(",");
        String startTimeStr = null;
        String endTimeStr = null;
        if (timeRange.length == 2) {
            startTimeStr = timeRange[0];
            endTimeStr = timeRange[1];
        } else if (timeRange.length == 1) {
            startTimeStr = timeRange[0];
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startTime = null;
            LocalDateTime endTime = null;
            if (startTimeStr != null) {
                startTime = LocalDateTime.parse(startTimeStr.trim(), formatter);
            }
            if (endTimeStr != null) {
                endTime = LocalDateTime.parse(endTimeStr.trim(), formatter);
            }
            if (startTime != null && endTime != null) {
                long startTimeMillis = startTime.toInstant(ZoneOffset.UTC).toEpochMilli();
                long endTimeMillis = endTime.toInstant(ZoneOffset.UTC).toEpochMilli();
                params.put("heartBeatStartTime", startTimeMillis);
                params.put("heartBeatEndTime", endTimeMillis);
            } else if (startTime != null) {
                long startTimeMillis = startTime.toInstant(ZoneOffset.UTC).toEpochMilli();
                params.put("heartBeatStartTime", startTimeMillis);
            } else if (endTime != null) {
                long endTimeMillis = endTime.toInstant(ZoneOffset.UTC).toEpochMilli();
                params.put("heartBeatEndTime", endTimeMillis);
            }
        }
        catch (Exception e) {
            LOG.error("transform heartBeatTimeRange error.", (Throwable)e);
        }
    }

    private RestClient getClient() {
        return this.client.getHttpClient();
    }
}

