/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.client.util.RssClientConfig;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.shaded.com.google.common.collect.ImmutableSet;

public class RssTezConfig {
    public static final String TEZ_RSS_CONFIG_PREFIX = "tez.";
    public static final String RSS_CLIENT_HEARTBEAT_THREAD_NUM = "tez.rss.client.heartBeat.threadNum";
    public static final int RSS_CLIENT_HEARTBEAT_THREAD_NUM_DEFAULT_VALUE = 4;
    public static final String RSS_CLIENT_TYPE = "tez.rss.client.type";
    public static final String RSS_CLIENT_TYPE_DEFAULT_VALUE = "GRPC";
    public static final String RSS_CLIENT_RETRY_MAX = "tez.rss.client.retry.max";
    public static final int RSS_CLIENT_RETRY_MAX_DEFAULT_VALUE = 50;
    public static final String RSS_CLIENT_RETRY_INTERVAL_MAX = "tez.rss.client.retry.interval.max";
    public static final long RSS_CLIENT_RETRY_INTERVAL_MAX_DEFAULT_VALUE = 10000L;
    public static final String RSS_COORDINATOR_QUORUM = "tez.rss.coordinator.quorum";
    public static final String RSS_DATA_REPLICA = "tez.rss.data.replica";
    public static final int RSS_DATA_REPLICA_DEFAULT_VALUE = 1;
    public static final String RSS_DATA_REPLICA_WRITE = "tez.rss.data.replica.write";
    public static final int RSS_DATA_REPLICA_WRITE_DEFAULT_VALUE = 1;
    public static final String RSS_DATA_REPLICA_READ = "tez.rss.data.replica.read";
    public static final int RSS_DATA_REPLICA_READ_DEFAULT_VALUE = 1;
    public static final String RSS_DATA_REPLICA_SKIP_ENABLED = "tez.rss.data.replica.skip.enabled";
    public static final String RSS_DATA_TRANSFER_POOL_SIZE = "tez.rss.client.data.transfer.pool.size";
    public static final int RSS_DATA_TRANSFER_POOL_SIZE_DEFAULT_VALUE = RssClientConfig.RSS_DATA_TRANFER_POOL_SIZE_DEFAULT_VALUE;
    public static final String RSS_DATA_COMMIT_POOL_SIZE = "tez.rss.client.data.commit.pool.size";
    public static final int RSS_DATA_COMMIT_POOL_SIZE_DEFAULT_VALUE = -1;
    public static final boolean RSS_DATA_REPLICA_SKIP_ENABLED_DEFAULT_VALUE = true;
    public static final String RSS_HEARTBEAT_INTERVAL = "tez.rss.heartbeat.interval";
    public static final long RSS_HEARTBEAT_INTERVAL_DEFAULT_VALUE = 10000L;
    public static final String RSS_HEARTBEAT_TIMEOUT = "tez.rss.heartbeat.timeout";
    public static final long RSS_CLIENT_SEND_CHECK_TIMEOUT_MS_DEFAULT_VALUE = 600000L;
    public static final String RSS_RUNTIME_IO_SORT_MB = "tez.rss.runtime.io.sort.mb";
    public static final int RSS_DEFAULT_RUNTIME_IO_SORT_MB = 100;
    public static final String RSS_CLIENT_SORT_MEMORY_USE_THRESHOLD = "tez.rss.client.sort.memory.use.threshold";
    public static final double RSS_CLIENT_DEFAULT_SORT_MEMORY_USE_THRESHOLD = (double)0.9f;
    public static final String RSS_CLIENT_MAX_BUFFER_SIZE = "tez.rss.client.max.buffer.size";
    public static final long RSS_CLIENT_DEFAULT_MAX_BUFFER_SIZE = 3072L;
    public static final String RSS_WRITER_BUFFER_SIZE = "tez.rss.writer.buffer.size";
    public static final long RSS_DEFAULT_WRITER_BUFFER_SIZE = 0xE00000L;
    public static final String RSS_CLIENT_MEMORY_THRESHOLD = "tez.rss.client.memory.threshold";
    public static final double RSS_CLIENT_DEFAULT_MEMORY_THRESHOLD = (double)0.8f;
    public static final String RSS_CLIENT_SEND_THREAD_NUM = "tez.rss.client.send.thread.num";
    public static final int RSS_CLIENT_DEFAULT_THREAD_NUM = 5;
    public static final String RSS_CLIENT_SEND_THRESHOLD = "tez.rss.client.send.threshold";
    public static final double RSS_CLIENT_DEFAULT_SEND_THRESHOLD = (double)0.2f;
    public static final String RSS_CLIENT_BATCH_TRIGGER_NUM = "tez.rss.client.batch.trigger.num";
    public static final int RSS_CLIENT_DEFAULT_BATCH_TRIGGER_NUM = 50;
    public static final String RSS_DEFAULT_STORAGE_TYPE = "MEMORY";
    public static final String RSS_CLIENT_SEND_CHECK_INTERVAL_MS = "tez.rss.client.send.check.interval.ms";
    public static final long RSS_CLIENT_DEFAULT_SEND_CHECK_INTERVAL_MS = 500L;
    public static final String RSS_CLIENT_SEND_CHECK_TIMEOUT_MS = "tez.rss.client.send.check.timeout.ms";
    public static final long RSS_CLIENT_DEFAULT_SEND_CHECK_TIMEOUT_MS = 600000L;
    public static final String RSS_CLIENT_BITMAP_NUM = "tez.rss.client.bitmap.num";
    public static final int RSS_CLIENT_DEFAULT_BITMAP_NUM = 1;
    public static final String HIVE_TEZ_LOG_LEVEL = "hive.tez.log.level";
    public static final String DEFAULT_HIVE_TEZ_LOG_LEVEL = "INFO";
    public static final String DEBUG_HIVE_TEZ_LOG_LEVEL = "debug";
    public static final String RSS_STORAGE_TYPE = "tez.rss.storage.type";
    public static final String RSS_STORAGE_TYPE_DEFAULT_VALUE = "MEMORY_LOCALFILE";
    public static final String RSS_DYNAMIC_CLIENT_CONF_ENABLED = "tez.rss.dynamicClientConf.enabled";
    public static final boolean RSS_DYNAMIC_CLIENT_CONF_ENABLED_DEFAULT_VALUE = true;
    public static final String RSS_CLIENT_ASSIGNMENT_TAGS = "tez.rss.client.assignment.tags";
    public static final String RSS_CLIENT_ASSIGNMENT_SHUFFLE_SERVER_NUMBER = "rss.client.assignment.shuffle.nodes.max";
    public static final int RSS_CLIENT_ASSIGNMENT_SHUFFLE_SERVER_NUMBER_DEFAULT_VALUE = -1;
    public static final String RSS_CLIENT_ASSIGNMENT_RETRY_INTERVAL = "tez.rss.client.assignment.retry.interval";
    public static final long RSS_CLIENT_ASSIGNMENT_RETRY_INTERVAL_DEFAULT_VALUE = 65000L;
    public static final String RSS_CLIENT_ASSIGNMENT_RETRY_TIMES = "tez.rss.client.assignment.retry.times";
    public static final int RSS_CLIENT_ASSIGNMENT_RETRY_TIMES_DEFAULT_VALUE = 3;
    public static final String RSS_ESTIMATE_SERVER_ASSIGNMENT_ENABLED = "tez.rss.estimate.server.assignment.enabled";
    public static final boolean RSS_ESTIMATE_SERVER_ASSIGNMENT_ENABLED_DEFAULT_VALUE = false;
    public static final String RSS_ESTIMATE_TASK_CONCURRENCY_DYNAMIC_FACTOR = "tez.rss.estimate.task.concurrency.dynamic.factor";
    public static final double RSS_ESTIMATE_TASK_CONCURRENCY_DYNAMIC_FACTOR_DEFAULT_VALUE = 1.0;
    public static final String RSS_ESTIMATE_TASK_CONCURRENCY_PER_SERVER = "tez.rss.estimate.task.concurrency.per.server";
    public static final int RSS_ESTIMATE_TASK_CONCURRENCY_PER_SERVER_DEFAULT_VALUE = 80;
    public static final String RSS_CLIENT_READ_BUFFER_SIZE = "tez.rss.client.read.buffer.size";
    public static final String RSS_CLIENT_READ_BUFFER_SIZE_DEFAULT_VALUE = "14m";
    public static final String RSS_PARTITION_NUM_PER_RANGE = "tez.rss.partitionNum.per.range";
    public static final int RSS_PARTITION_NUM_PER_RANGE_DEFAULT_VALUE = 1;
    public static final String RSS_REMOTE_STORAGE_PATH = "tez.rss.remote.storage.path";
    public static final String RSS_REMOTE_STORAGE_CONF = "tez.rss.remote.storage.conf";
    public static final String RSS_TEST_MODE_ENABLE = "tez.rss.test.mode.enable";
    public static final String RSS_AM_SHUFFLE_MANAGER_ADDRESS = "tez.rss.am.shuffle.manager.address";
    public static final String RSS_AM_SHUFFLE_MANAGER_PORT = "tez.rss.am.shuffle.manager.port";
    public static final String RSS_AM_SHUFFLE_MANAGER_DEBUG = "tez.rss.am.shuffle.manager.debug";
    public static final String RSS_AM_SLOW_START_ENABLE = "tez.rss.am.slow.start.enable";
    public static final Boolean RSS_AM_SLOW_START_ENABLE_DEFAULT = false;
    public static final String RSS_REDUCE_INITIAL_MEMORY = "tez.rss.reduce.initial.memory";
    public static final String RSS_ACCESS_TIMEOUT_MS = "tez.rss.access.timeout.ms";
    public static final int RSS_ACCESS_TIMEOUT_MS_DEFAULT_VALUE = 10000;
    public static final Set<String> RSS_MANDATORY_CLUSTER_CONF = ImmutableSet.of("tez.rss.storage.type", "tez.rss.remote.storage.path");
    public static final String RSS_SHUFFLE_SOURCE_VERTEX_ID = "tez.rss.shuffle.source.vertex.id";
    public static final String RSS_SHUFFLE_DESTINATION_VERTEX_ID = "tez.rss.shuffle.destination.vertex.id";
    public static final String RSS_AVOID_RECOMPUTE_SUCCEEDED_TASK = "tez.rss.avoid.recompute.succeeded.task";
    public static final boolean RSS_AVOID_RECOMPUTE_SUCCEEDED_TASK_DEFAULT = false;
    public static final String RSS_REDUCE_REMOTE_SPILL_ENABLED = "tez.rss.reduce.remote.spill.enable";
    public static final boolean RSS_REDUCE_REMOTE_SPILL_ENABLED_DEFAULT = false;
    public static final String RSS_REDUCE_REMOTE_SPILL_REPLICATION = "tez.rss.reduce.remote.spill.replication";
    public static final int RSS_REDUCE_REMOTE_SPILL_REPLICATION_DEFAULT = 1;
    public static final String RSS_REDUCE_REMOTE_SPILL_RETRIES = "tez.rss.reduce.remote.spill.retries";
    public static final int RSS_REDUCE_REMOTE_SPILL_RETRIES_DEFAULT = 5;
    public static final String RSS_REMOTE_SPILL_STORAGE_PATH = "tez.rss.remote.spill.storage.path";
    public static final String RSS_SHUFFLE_MODE = "tez.shuffle.mode";
    public static final String DEFAULT_RSS_SHUFFLE_MODE = "remote";

    public static RssConf toRssConf(Configuration jobConf) {
        RssConf rssConf = new RssConf();
        for (Map.Entry entry : jobConf) {
            String key = (String)entry.getKey();
            if (!key.startsWith(TEZ_RSS_CONFIG_PREFIX)) continue;
            key = key.substring(TEZ_RSS_CONFIG_PREFIX.length());
            rssConf.setString(key, (String)entry.getValue());
        }
        return rssConf;
    }
}

