/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.osgi.service.blueprint.container.ReifiedType;

public class NullProxy
implements AggregateConverter.Convertible {
    private static final Map<Class<?>, Object> returns;
    private final ExtendedBlueprintContainer container;
    private final InvocationHandler nullProxyHandler = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName()) && (args == null || args.length == 0)) {
                return NullProxy.this.toString();
            }
            return returns.get(method.getReturnType());
        }
    };

    public NullProxy(ExtendedBlueprintContainer container) {
        this.container = container;
    }

    @Override
    public Object convert(ReifiedType type) {
        ClassLoader cl = this.container.getClassLoader();
        return Proxy.newProxyInstance(cl, new Class[]{type.getRawClass()}, this.nullProxyHandler);
    }

    public String toString() {
        return "Aries Blueprint Null Proxy";
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> tmp = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        tmp.put(Boolean.TYPE, Boolean.valueOf(false));
        tmp.put(Byte.TYPE, Byte.valueOf("0"));
        tmp.put(Short.TYPE, Short.valueOf("0"));
        tmp.put(Character.TYPE, Character.valueOf('\u0000'));
        tmp.put(Integer.TYPE, Integer.valueOf("0"));
        tmp.put(Float.TYPE, Float.valueOf("0"));
        tmp.put(Long.TYPE, Long.valueOf("0"));
        tmp.put(Double.class, Double.valueOf("0"));
        returns = Collections.unmodifiableMap(tmp);
    }
}

