/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.util.regex.Pattern;
import org.apache.batik.test.svg.ParametrizedRenderingAccuracyTest;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGAnimatedRotateCenterTest
extends ParametrizedRenderingAccuracyTest {
    private float viewCenter = 100.0f;
    private float shapeCenter = 50.0f;
    private float animDur = 4.0f;
    private float cx;
    private float cy;
    private float angle;

    public SVGAnimatedRotateCenterTest() {
        super.setValidating(false);
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        String[] split = this.parameter.split(",", 3);
        try {
            this.cx = Float.parseFloat(split[0]);
            this.cy = Float.parseFloat(split[1]);
            this.angle = Float.parseFloat(split[2]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException(id, e);
        }
    }

    public void setViewCenter(float viewCenter) {
        this.viewCenter = viewCenter;
    }

    public void setShapeCenter(float shapeCenter) {
        this.shapeCenter = shapeCenter;
    }

    public void setAnimDur(float dur) {
        this.animDur = dur;
    }

    @Override
    protected String buildRefImgURL(String svgDir, String svgFile) {
        String parameterSuffx = Pattern.quote(this.parameter + ".png") + "$";
        return super.buildRefImgURL(svgDir, svgFile).replaceFirst(parameterSuffx, ".png");
    }

    @Override
    protected Document manipulateSVGDocument(Document doc) {
        doc.getDocumentElement().setAttribute("shape-rendering", "crispEdges");
        Element container = doc.getElementById("container");
        Element rect = SVGAnimatedRotateCenterTest.getElement(container, "rect", 0);
        Element transform = SVGAnimatedRotateCenterTest.getElement(rect, "animateTransform", 0);
        container.setAttribute("transform", "translate(" + (this.viewCenter - this.cx) + " " + (this.viewCenter - this.cy) + ")");
        rect.setAttribute("x", String.valueOf(this.cx - this.shapeCenter));
        rect.setAttribute("y", String.valueOf(this.cy - this.shapeCenter));
        transform.setAttribute("from", "0 " + this.cx + " " + this.cy);
        transform.setAttribute("to", "360 " + this.cx + " " + this.cy);
        return doc;
    }

    private static Element getElement(Element container, String name, int index) {
        if (container == null) {
            throw new IllegalStateException("null container element");
        }
        NodeList elements = container.getElementsByTagName(name);
        if (index >= elements.getLength()) {
            throw new IllegalStateException("Could not find " + name + "[" + index + "] inside" + container.getTagName());
        }
        return (Element)elements.item(index);
    }

    @Override
    public ImageTranscoder getTestImageTranscoder() {
        ImageTranscoder transcoder = super.getTestImageTranscoder();
        float snapshotTime = this.angle * this.animDur / 360.0f;
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_SNAPSHOT_TIME, (Object)Float.valueOf(snapshotTime));
        return transcoder;
    }
}

