/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobManagerService.class);
    private final Notebook notebook;
    private final AuthorizationService authorizationService;
    private final ZeppelinConfiguration zConf;

    @Inject
    public JobManagerService(Notebook notebook, AuthorizationService authorizationService, ZeppelinConfiguration zConf) {
        this.notebook = notebook;
        this.authorizationService = authorizationService;
        this.zConf = zConf;
    }

    public List<NoteJobInfo> getNoteJobInfo(String noteId, ServiceContext context, ServiceCallback<List<NoteJobInfo>> callback) throws IOException {
        if (!this.zConf.isJobManagerEnabled()) {
            return new ArrayList<NoteJobInfo>();
        }
        return (List)this.notebook.processNote(noteId, jobNote -> {
            ArrayList<NoteJobInfo> notesJobInfo = new ArrayList<NoteJobInfo>();
            if (jobNote == null) {
                callback.onFailure(new IOException("Note " + noteId + " not found"), context);
            } else {
                notesJobInfo.add(new NoteJobInfo(jobNote));
                callback.onSuccess(notesJobInfo, context);
            }
            return notesJobInfo;
        });
    }

    public List<NoteJobInfo> getNoteJobInfoByUnixTime(long lastUpdateServerUnixTime, ServiceContext context, ServiceCallback<List<NoteJobInfo>> callback) throws IOException {
        if (!this.zConf.isJobManagerEnabled()) {
            return new ArrayList<NoteJobInfo>();
        }
        LinkedList<NoteJobInfo> notesJobInfo = new LinkedList<NoteJobInfo>();
        for (NoteInfo noteInfo : this.notebook.getNotesInfo()) {
            if (!this.authorizationService.isOwner(context.getUserAndRoles(), noteInfo.getId())) continue;
            NoteJobInfo noteJobInfo = (NoteJobInfo)this.notebook.processNote(noteInfo.getId(), NoteJobInfo::new);
            if (noteJobInfo.unixTimeLastRun <= lastUpdateServerUnixTime) continue;
            notesJobInfo.add(noteJobInfo);
        }
        callback.onSuccess(notesJobInfo, context);
        return notesJobInfo;
    }

    public void removeNoteJobInfo(String noteId, ServiceContext context, ServiceCallback<List<NoteJobInfo>> callback) throws IOException {
        if (!this.zConf.isJobManagerEnabled()) {
            return;
        }
        ArrayList<NoteJobInfo> notesJobInfo = new ArrayList<NoteJobInfo>();
        notesJobInfo.add(new NoteJobInfo(noteId, true));
        callback.onSuccess(notesJobInfo, context);
    }

    private static long getUnixTimeLastRunParagraph(Paragraph paragraph) {
        if (paragraph.isTerminated() && paragraph.getDateFinished() != null) {
            return paragraph.getDateFinished().getTime();
        }
        if (paragraph.isRunning()) {
            return new Date().getTime();
        }
        return paragraph.getDateCreated().getTime();
    }

    public static class NoteJobInfo {
        private String noteId;
        private String noteName;
        private String noteType;
        private String interpreter;
        private boolean isRunningJob;
        private boolean isRemoved = false;
        private long unixTimeLastRun;
        private List<ParagraphJobInfo> paragraphs;

        public NoteJobInfo(Note note) {
            boolean isNoteRunning = false;
            long lastRunningUnixTime = 0L;
            this.noteId = note.getId();
            this.noteName = note.getName();
            this.noteType = this.isCron(note) ? "cron" : "normal";
            this.interpreter = note.getDefaultInterpreterGroup();
            this.paragraphs = new ArrayList<ParagraphJobInfo>();
            for (Paragraph paragraph : note.getParagraphs()) {
                if (paragraph.getStatus().isRunning()) {
                    isNoteRunning = true;
                }
                ParagraphJobInfo paragraphItem = new ParagraphJobInfo(paragraph);
                lastRunningUnixTime = JobManagerService.getUnixTimeLastRunParagraph(paragraph);
                this.paragraphs.add(paragraphItem);
            }
            this.isRunningJob = isNoteRunning;
            this.unixTimeLastRun = lastRunningUnixTime;
        }

        private boolean isCron(Note note) {
            return note.getConfig().containsKey("cron") && !StringUtils.isBlank((CharSequence)note.getConfig().get("cron").toString());
        }

        public NoteJobInfo(String noteId, boolean isRemoved) {
            this.noteId = noteId;
            this.isRemoved = isRemoved;
        }
    }

    public static class ParagraphJobInfo {
        private String id;
        private String name;
        private Job.Status status;

        public ParagraphJobInfo(Paragraph p) {
            this.id = p.getId();
            this.name = StringUtils.isBlank((CharSequence)p.getTitle()) ? p.getId() : p.getTitle();
            this.status = p.getStatus();
        }
    }
}

