/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class Repository
implements JsonSerializable {
    private static final Gson gson = new Gson();
    private boolean snapshot = false;
    private String id;
    private String url;
    private String username = null;
    private String password = null;
    private String proxyProtocol = "HTTP";
    private String proxyHost = null;
    private Integer proxyPort = null;
    private String proxyLogin = null;
    private String proxyPassword = null;

    public Repository(String id) {
        this.id = id;
    }

    public Repository url(String url) {
        this.url = url;
        return this;
    }

    public Repository snapshot() {
        this.snapshot = true;
        return this;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public Repository username(String username) {
        this.username = username;
        return this;
    }

    public Repository password(String password) {
        this.password = password;
        return this;
    }

    public Repository credentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public Authentication getAuthentication() {
        Authentication auth = null;
        if (this.username != null && this.password != null) {
            auth = new AuthenticationBuilder().addUsername(this.username).addPassword(this.password).build();
        }
        return auth;
    }

    public Proxy getProxy() {
        if (StringUtils.isNotBlank((CharSequence)this.proxyHost) && this.proxyPort != null) {
            if (StringUtils.isNotBlank((CharSequence)this.proxyLogin)) {
                return new Proxy(this.proxyProtocol, this.proxyHost, this.proxyPort.intValue(), new AuthenticationBuilder().addUsername(this.proxyLogin).addPassword(this.proxyPassword).build());
            }
            return new Proxy(this.proxyProtocol, this.proxyHost, this.proxyPort.intValue(), null);
        }
        return null;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static Repository fromJson(String json) {
        return (Repository)gson.fromJson(json, Repository.class);
    }
}

