/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.user.AuthenticationInfo;

public class InterpreterContext {
    private static final ThreadLocal<InterpreterContext> threadIC = new ThreadLocal();
    private static final ConcurrentHashMap<Thread, InterpreterContext> allContexts = new ConcurrentHashMap();
    public InterpreterOutput out;
    private String noteId;
    private String noteName;
    private String replName;
    private String paragraphTitle;
    private String paragraphId;
    private String paragraphText;
    private AuthenticationInfo authenticationInfo;
    private Map<String, Object> config = new HashMap<String, Object>();
    private GUI gui = new GUI();
    private GUI noteGui = new GUI();
    private AngularObjectRegistry angularObjectRegistry;
    private ResourcePool resourcePool;
    private String interpreterClassName;
    private Map<String, Integer> progressMap;
    private Map<String, String> localProperties = new HashMap<String, String>();
    private RemoteInterpreterEventClient intpEventClient;

    public static InterpreterContext get() {
        return threadIC.get();
    }

    public static void set(InterpreterContext ic) {
        threadIC.set(ic);
        allContexts.put(Thread.currentThread(), ic);
    }

    public static void remove() {
        threadIC.remove();
        allContexts.remove(Thread.currentThread());
    }

    public static ConcurrentHashMap<Thread, InterpreterContext> getAllContexts() {
        return allContexts;
    }

    public static Builder builder() {
        return new Builder();
    }

    private InterpreterContext() {
    }

    public String getNoteId() {
        return this.noteId;
    }

    public String getNoteName() {
        return this.noteName;
    }

    public String getReplName() {
        return this.replName;
    }

    public String getParagraphId() {
        return this.paragraphId;
    }

    public void setParagraphId(String paragraphId) {
        this.paragraphId = paragraphId;
    }

    public String getParagraphText() {
        return this.paragraphText;
    }

    public String getParagraphTitle() {
        return this.paragraphTitle;
    }

    public Map<String, String> getLocalProperties() {
        return this.localProperties;
    }

    public String getStringLocalProperty(String key, String defaultValue) {
        return this.localProperties.getOrDefault(key, defaultValue);
    }

    public int getIntLocalProperty(String key, int defaultValue) {
        return Integer.parseInt(this.localProperties.getOrDefault(key, "" + defaultValue));
    }

    public long getLongLocalProperty(String key, int defaultValue) {
        return Long.parseLong(this.localProperties.getOrDefault(key, "" + defaultValue));
    }

    public double getDoubleLocalProperty(String key, double defaultValue) {
        return Double.parseDouble(this.localProperties.getOrDefault(key, "" + defaultValue));
    }

    public boolean getBooleanLocalProperty(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.localProperties.getOrDefault(key, "" + defaultValue));
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public GUI getGui() {
        return this.gui;
    }

    public GUI getNoteGui() {
        return this.noteGui;
    }

    public AngularObjectRegistry getAngularObjectRegistry() {
        return this.angularObjectRegistry;
    }

    public void setAngularObjectRegistry(AngularObjectRegistry angularObjectRegistry) {
        this.angularObjectRegistry = angularObjectRegistry;
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    public String getInterpreterClassName() {
        return this.interpreterClassName;
    }

    public void setInterpreterClassName(String className) {
        this.interpreterClassName = className;
    }

    public RemoteInterpreterEventClient getIntpEventClient() {
        return this.intpEventClient;
    }

    public void setIntpEventClient(RemoteInterpreterEventClient intpEventClient) {
        this.intpEventClient = intpEventClient;
    }

    public InterpreterOutput out() {
        return this.out;
    }

    public void setProgress(int n) {
        if (this.progressMap != null) {
            n = Math.max(n, 0);
            n = Math.min(n, 100);
            this.progressMap.put(this.paragraphId, n);
        }
    }

    public static class Builder {
        private InterpreterContext context = new InterpreterContext();

        public Builder setNoteId(String noteId) {
            this.context.noteId = noteId;
            return this;
        }

        public Builder setNoteName(String noteName) {
            this.context.noteName = noteName;
            return this;
        }

        public Builder setParagraphId(String paragraphId) {
            this.context.paragraphId = paragraphId;
            return this;
        }

        public Builder setInterpreterClassName(String intpClassName) {
            this.context.interpreterClassName = intpClassName;
            return this;
        }

        public Builder setAngularObjectRegistry(AngularObjectRegistry angularObjectRegistry) {
            this.context.angularObjectRegistry = angularObjectRegistry;
            return this;
        }

        public Builder setResourcePool(ResourcePool resourcePool) {
            this.context.resourcePool = resourcePool;
            return this;
        }

        public Builder setReplName(String replName) {
            this.context.replName = replName;
            return this;
        }

        public Builder setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
            this.context.authenticationInfo = authenticationInfo;
            return this;
        }

        public Builder setConfig(Map<String, Object> config) {
            if (config != null) {
                this.context.config = new HashMap<String, Object>(config);
            }
            return this;
        }

        public Builder setGUI(GUI gui) {
            this.context.gui = gui;
            return this;
        }

        public Builder setNoteGUI(GUI noteGUI) {
            this.context.noteGui = noteGUI;
            return this;
        }

        public Builder setInterpreterOut(InterpreterOutput out) {
            this.context.out = out;
            return this;
        }

        public Builder setIntpEventClient(RemoteInterpreterEventClient intpEventClient) {
            this.context.intpEventClient = intpEventClient;
            return this;
        }

        public Builder setProgressMap(Map<String, Integer> progressMap) {
            this.context.progressMap = progressMap;
            return this;
        }

        public Builder setParagraphText(String paragraphText) {
            this.context.paragraphText = paragraphText;
            return this;
        }

        public Builder setParagraphTitle(String paragraphTitle) {
            this.context.paragraphTitle = paragraphTitle;
            return this;
        }

        public Builder setLocalProperties(Map<String, String> localProperties) {
            this.context.localProperties = localProperties;
            return this;
        }

        public InterpreterContext build() {
            return this.context;
        }
    }
}

