/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.Cancellable;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.QueryApi;
import com.influxdb.client.domain.Dialect;
import com.influxdb.client.domain.Query;
import com.influxdb.client.internal.AbstractInfluxDBClient;
import com.influxdb.client.service.QueryService;
import com.influxdb.internal.AbstractQueryApi;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.influxdb.query.internal.FluxCsvParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import retrofit2.Call;

final class QueryApiImpl
extends AbstractQueryApi
implements QueryApi {
    private static final Logger LOG = Logger.getLogger(QueryApiImpl.class.getName());
    private final QueryService service;
    private final InfluxDBClientOptions options;

    QueryApiImpl(@Nonnull QueryService service, @Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull(service, "service");
        Arguments.checkNotNull(options, "options");
        this.service = service;
        this.options = options;
    }

    @Override
    @Nonnull
    public List<FluxTable> query(@Nonnull String query) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        return this.query(query, this.options.getOrg());
    }

    @Override
    @Nonnull
    public List<FluxTable> query(@Nonnull String query, @Nonnull String org) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        return this.query(new Query().query(query).dialect(AbstractInfluxDBClient.DEFAULT_DIALECT), org);
    }

    @Override
    @Nonnull
    public List<FluxTable> query(@Nonnull Query query) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        return this.query(query, this.options.getOrg());
    }

    @Override
    @Nonnull
    public List<FluxTable> query(@Nonnull Query query, @Nonnull String org) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        FluxCsvParser.FluxResponseConsumerTable consumer = new FluxCsvParser.FluxResponseConsumerTable(this.fluxCsvParser);
        this.query(query, org, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return consumer.getTables();
    }

    @Override
    @Nonnull
    public <M> List<M> query(@Nonnull String query, @Nonnull Class<M> measurementType) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        return this.query(query, this.options.getOrg(), measurementType);
    }

    @Override
    @Nonnull
    public <M> List<M> query(@Nonnull String query, @Nonnull String org, @Nonnull Class<M> measurementType) {
        Arguments.checkNonEmpty(query, "query");
        Query dialect = new Query().query(query).dialect(AbstractInfluxDBClient.DEFAULT_DIALECT);
        return this.query(dialect, org, measurementType);
    }

    @Override
    @Nonnull
    public <M> List<M> query(@Nonnull Query query, @Nonnull Class<M> measurementType) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        return this.query(query, this.options.getOrg(), measurementType);
    }

    @Override
    @Nonnull
    public <M> List<M> query(@Nonnull Query query, @Nonnull String org, final @Nonnull Class<M> measurementType) {
        Arguments.checkNotNull(query, "query");
        final ArrayList measurements = new ArrayList();
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                measurements.add(QueryApiImpl.this.resultMapper.toPOJO(record, measurementType));
            }
        };
        this.query(query, org, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return measurements;
    }

    @Override
    public void query(@Nonnull String query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), onNext);
    }

    @Override
    public void query(@Nonnull String query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNotNull(onNext, "onNext");
        this.query(query, org, onNext, (Consumer<? super Throwable>)ERROR_CONSUMER);
    }

    @Override
    public void query(@Nonnull Query query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), onNext);
    }

    @Override
    public void query(@Nonnull Query query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNotNull(onNext, "onNext");
        this.query(query, org, onNext, (Consumer<? super Throwable>)ERROR_CONSUMER);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), measurementType, onNext);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull String org, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(measurementType, "measurementType");
        this.query(query, org, measurementType, onNext, (Consumer<? super Throwable>)ERROR_CONSUMER);
    }

    @Override
    public <M> void query(@Nonnull Query query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), measurementType, onNext);
    }

    @Override
    public <M> void query(@Nonnull Query query, @Nonnull String org, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(measurementType, "measurementType");
        this.query(query, org, measurementType, onNext, (Consumer<? super Throwable>)ERROR_CONSUMER);
    }

    @Override
    public void query(@Nonnull String query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), onNext, onError);
    }

    @Override
    public void query(@Nonnull String query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        this.query(query, org, onNext, onError, EMPTY_ACTION);
    }

    @Override
    public void query(@Nonnull Query query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), onNext, onError);
    }

    @Override
    public void query(@Nonnull Query query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        this.query(query, org, onNext, onError, EMPTY_ACTION);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), measurementType, onNext, onError);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull String org, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(measurementType, "measurementType");
        this.query(query, org, measurementType, onNext, onError, EMPTY_ACTION);
    }

    @Override
    public <M> void query(@Nonnull Query query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), measurementType, onNext, onError);
    }

    @Override
    public <M> void query(@Nonnull Query query, @Nonnull String org, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(measurementType, "measurementType");
        this.query(query, org, measurementType, onNext, onError, EMPTY_ACTION);
    }

    @Override
    public void query(@Nonnull String query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), onNext, onError, onComplete);
    }

    @Override
    public void query(@Nonnull String query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        Query queryObj = new Query().query(query).dialect(AbstractInfluxDBClient.DEFAULT_DIALECT);
        this.query(queryObj, org, onNext, onError, onComplete);
    }

    @Override
    public void query(@Nonnull Query query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), onNext, onError, onComplete);
    }

    @Override
    public void query(@Nonnull Query query, @Nonnull String org, final @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                onNext.accept(cancellable, record);
            }
        };
        this.query(query, org, consumer, onError, onComplete, true);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), measurementType, onNext, onError, onComplete);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull String org, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        Arguments.checkNotNull(measurementType, "measurementType");
        Query queryObj = new Query().query(query).dialect(AbstractInfluxDBClient.DEFAULT_DIALECT);
        this.query(queryObj, org, measurementType, onNext, onError, onComplete);
    }

    @Override
    public <M> void query(@Nonnull Query query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.query(query, this.options.getOrg(), measurementType, onNext, onError, onComplete);
    }

    @Override
    public <M> void query(@Nonnull Query query, @Nonnull String org, final @Nonnull Class<M> measurementType, final @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onNext, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        Arguments.checkNotNull(measurementType, "measurementType");
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            @Override
            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                onNext.accept(cancellable, QueryApiImpl.this.resultMapper.toPOJO(record, measurementType));
            }
        };
        this.query(query, org, consumer, onError, onComplete, true);
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull String query) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        return this.queryRaw(query, this.options.getOrg());
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull String query, @Nonnull String org) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        return this.queryRaw(new Query().query(query), org);
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull String query, @Nullable Dialect dialect) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        return this.queryRaw(query, dialect, this.options.getOrg());
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull String org) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        return this.queryRaw(new Query().query(query).dialect(dialect), org);
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull Query query) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        return this.queryRaw(query, this.options.getOrg());
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull Query query, @Nonnull String org) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        ArrayList rows = new ArrayList();
        BiConsumer<Cancellable, String> consumer = (cancellable, row) -> rows.add(row);
        this.queryRaw(query, org, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return String.join((CharSequence)"\n", rows);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, this.options.getOrg(), onResponse);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onResponse, "onResponse");
        this.queryRaw(query, null, org, onResponse);
    }

    @Override
    public void queryRaw(@Nonnull Query query, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, this.options.getOrg(), onResponse);
    }

    @Override
    public void queryRaw(@Nonnull Query query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onResponse, "onResponse");
        this.queryRaw(query, org, onResponse, (Consumer<? super Throwable>)ERROR_CONSUMER);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, dialect, this.options.getOrg(), onResponse);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onResponse, "onResponse");
        this.queryRaw(query, dialect, org, onResponse, ERROR_CONSUMER);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, this.options.getOrg(), onResponse, onError);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNotNull(onResponse, "onNext");
        Arguments.checkNotNull(onError, "onError");
        this.queryRaw(query, org, onResponse, onError, EMPTY_ACTION);
    }

    @Override
    public void queryRaw(@Nonnull Query query, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, this.options.getOrg(), onResponse, onError);
    }

    @Override
    public void queryRaw(@Nonnull Query query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        this.queryRaw(query, org, onResponse, onError, EMPTY_ACTION);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, this.options.getOrg(), onResponse, onError);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onResponse, "onNext");
        Arguments.checkNotNull(onError, "onError");
        this.queryRaw(query, dialect, org, onResponse, onError, EMPTY_ACTION);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, this.options.getOrg(), onResponse, onError, onComplete);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onResponse, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        this.queryRaw(query, null, org, onResponse, onError, onComplete);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, dialect, this.options.getOrg(), onResponse, onError, onComplete);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(onResponse, "onNext");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        this.queryRaw(new Query().query(query).dialect(dialect), org, onResponse, onError, onComplete, true);
    }

    @Override
    public void queryRaw(@Nonnull Query query, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.queryRaw(query, this.options.getOrg(), onResponse, onError, onComplete);
    }

    @Override
    public void queryRaw(@Nonnull Query query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        this.queryRaw(query, org, onResponse, onError, onComplete, true);
    }

    private void query(@Nonnull Query query, @Nonnull String org, @Nonnull FluxCsvParser.FluxResponseConsumer responseConsumer, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Call<ResponseBody> queryCall = this.service.postQueryResponseBody(null, "application/json", null, org, null, query);
        LOG.log(Level.FINEST, "Prepare query \"{0}\" with dialect \"{1}\" on organization \"{2}\".", new Object[]{query, query.getDialect(), org});
        this.query(queryCall, responseConsumer, onError, onComplete, asynchronously);
    }

    private void queryRaw(@Nonnull Query query, @Nonnull String org, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Call<ResponseBody> queryCall = this.service.postQueryResponseBody(null, "application/json", null, org, null, query);
        LOG.log(Level.FINEST, "Prepare raw query \"{0}\" with dialect \"{1}\" on organization \"{2}\".", new Object[]{query, query.getDialect(), org});
        this.queryRaw(queryCall, onResponse, onError, onComplete, asynchronously);
    }
}

