/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.SourcesApi;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.Buckets;
import com.influxdb.client.domain.HealthCheck;
import com.influxdb.client.domain.Source;
import com.influxdb.client.domain.Sources;
import com.influxdb.client.internal.InfluxDBClientImpl;
import com.influxdb.client.service.SourcesService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class SourcesApiImpl
extends AbstractRestClient
implements SourcesApi {
    private static final Logger LOG = Logger.getLogger(SourcesApiImpl.class.getName());
    private final InfluxDBClientImpl influxDBClient;
    private final SourcesService service;

    SourcesApiImpl(@Nonnull SourcesService service, @Nonnull InfluxDBClientImpl influxDBClient) {
        Arguments.checkNotNull(service, "service");
        Arguments.checkNotNull(influxDBClient, "influxDBClient");
        this.service = service;
        this.influxDBClient = influxDBClient;
    }

    @Override
    @Nonnull
    public Source createSource(@Nonnull Source source) {
        Arguments.checkNotNull(source, "Source is required");
        Call<Source> call = this.service.postSources(source, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Source updateSource(@Nonnull Source source) {
        Arguments.checkNotNull(source, "Source is required");
        Call<Source> call = this.service.patchSourcesID(source.getId(), source, null);
        return this.execute(call);
    }

    @Override
    public void deleteSource(@Nonnull Source source) {
        Arguments.checkNotNull(source, "Source is required");
        this.deleteSource(source.getId());
    }

    @Override
    public void deleteSource(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Call<Void> call = this.service.deleteSourcesID(sourceID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Source cloneSource(@Nonnull String clonedName, @Nonnull String sourceID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Source source = this.findSourceByID(sourceID);
        return this.cloneSource(clonedName, source);
    }

    @Override
    @Nonnull
    public Source cloneSource(@Nonnull String clonedName, @Nonnull Source source) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(source, "source");
        Source cloned = new Source();
        cloned.setName(clonedName);
        cloned.setOrgID(source.getOrgID());
        cloned.setDefault(source.getDefault());
        cloned.setType(source.getType());
        cloned.setUrl(source.getUrl());
        cloned.setInsecureSkipVerify(source.getInsecureSkipVerify());
        cloned.setTelegraf(source.getTelegraf());
        cloned.setToken(source.getToken());
        cloned.setUsername(source.getUsername());
        cloned.setPassword(source.getPassword());
        cloned.setSharedSecret(source.getSharedSecret());
        cloned.setMetaUrl(source.getMetaUrl());
        cloned.setDefaultRP(source.getDefaultRP());
        return this.createSource(cloned);
    }

    @Override
    @Nonnull
    public Source findSourceByID(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Call<Source> call = this.service.getSourcesID(sourceID, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Source> findSources() {
        Call<Sources> sourcesCall = this.service.getSources(null, null);
        Sources sources = this.execute(sourcesCall);
        LOG.log(Level.FINEST, "findSources found: {0}", sources);
        return sources.getSources();
    }

    @Override
    @Nullable
    public List<Bucket> findBucketsBySource(@Nonnull Source source) {
        Arguments.checkNotNull(source, "Source is required");
        return this.findBucketsBySourceID(source.getId());
    }

    @Override
    @Nonnull
    public List<Bucket> findBucketsBySourceID(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Call<Buckets> call = this.service.getSourcesIDBuckets(sourceID, null, null);
        return this.execute(call).getBuckets();
    }

    @Override
    @Nonnull
    public HealthCheck health(@Nonnull Source source) {
        Arguments.checkNotNull(source, "Source is required");
        return this.health(source.getId());
    }

    @Override
    @Nonnull
    public HealthCheck health(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        return this.influxDBClient.health(this.service.getSourcesIDHealth(sourceID, null));
    }
}

