/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.fn;

import com.hubspot.jinjava.el.ext.AbstractCallableMethod;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MacroFunction
extends AbstractCallableMethod {
    private final List<Node> content;
    private final boolean caller;
    private final Context localContextScope;
    private final int definitionLineNumber;
    private final int definitionStartPosition;
    private boolean deferred;

    public MacroFunction(List<Node> content, String name, LinkedHashMap<String, Object> argNamesWithDefaults, boolean caller, Context localContextScope, int lineNumber, int startPosition) {
        super(name, argNamesWithDefaults);
        this.content = content;
        this.caller = caller;
        this.localContextScope = localContextScope;
        this.definitionLineNumber = lineNumber;
        this.definitionStartPosition = startPosition;
        this.deferred = false;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public Object doEvaluate(Map<String, Object> argMap, Map<String, Object> kwargMap, List<Object> varArgs) {
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        Optional<String> importFile = Optional.ofNullable((String)this.localContextScope.get("import_resource_path"));
        importFile.ifPresent(path -> interpreter.getContext().getCurrentPathStack().pushWithoutCycleCheck((String)path, interpreter.getLineNumber(), interpreter.getPosition()));
        try {
            try (JinjavaInterpreter.InterpreterScopeClosable c = interpreter.enterScope();){
                interpreter.setLineNumber(this.definitionLineNumber);
                interpreter.setPosition(this.definitionStartPosition);
                for (Map.Entry scopeEntry : this.localContextScope.getScope().entrySet()) {
                    if (scopeEntry.getValue() instanceof MacroFunction) {
                        interpreter.getContext().addGlobalMacro((MacroFunction)scopeEntry.getValue());
                        continue;
                    }
                    interpreter.getContext().put(scopeEntry.getKey(), scopeEntry.getValue());
                }
                for (Map.Entry<Object, Object> argEntry : argMap.entrySet()) {
                    interpreter.getContext().put(argEntry.getKey(), argEntry.getValue());
                }
                interpreter.getContext().put("kwargs", kwargMap);
                interpreter.getContext().put("varargs", varArgs);
                LengthLimitingStringBuilder result = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
                for (Node node : this.content) {
                    result.append(node.render(interpreter));
                }
                if (!interpreter.getContext().getDeferredNodes().isEmpty()) {
                    throw new DeferredValueException(this.getName(), interpreter.getLineNumber(), interpreter.getPosition());
                }
                String string = result.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            importFile.ifPresent(path -> interpreter.getContext().getCurrentPathStack().pop());
        }
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean isCaller() {
        return this.caller;
    }

    public String reconstructImage() {
        if (this.content != null && !this.content.isEmpty()) {
            return this.content.get(0).getParent().reconstructImage();
        }
        return "";
    }
}

