/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.com.google.common.collect;

import org.apache.zeppelin.com.google.common.annotations.GwtCompatible;
import org.apache.zeppelin.com.google.common.annotations.GwtIncompatible;
import org.apache.zeppelin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.zeppelin.com.google.common.collect.ImmutableList;
import org.apache.zeppelin.com.google.common.collect.ImmutableSet;
import org.apache.zeppelin.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class IndexedImmutableSet<E>
extends ImmutableSet<E> {
    IndexedImmutableSet() {
    }

    abstract E get(int var1);

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.asList().copyIntoArray(dst, offset);
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableList<E>(){

            @Override
            public E get(int index) {
                return IndexedImmutableSet.this.get(index);
            }

            @Override
            boolean isPartialView() {
                return IndexedImmutableSet.this.isPartialView();
            }

            @Override
            public int size() {
                return IndexedImmutableSet.this.size();
            }
        };
    }
}

