/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.io.File;
import org.apache.zeppelin.interpreter.InterpreterException;

public class SparkRUtils {
    public static String getSparkRLib(boolean isSparkSupported) throws InterpreterException {
        Object sparkRLibPath;
        if (System.getenv("SPARK_HOME") != null) {
            sparkRLibPath = System.getenv("SPARK_HOME") + "/R/lib";
        } else if (System.getenv("ZEPPELIN_HOME") != null) {
            String interpreter = "r";
            if (isSparkSupported) {
                interpreter = "spark";
            }
            sparkRLibPath = System.getenv("ZEPPELIN_HOME") + "/interpreter/" + interpreter + "/R/lib";
            System.setProperty("spark.test.home", System.getenv("ZEPPELIN_HOME") + "/interpreter/" + interpreter);
        } else {
            sparkRLibPath = "sparkr";
        }
        if (!new File((String)sparkRLibPath).exists()) {
            throw new InterpreterException(String.format("sparkRLib '%s' doesn't exist", sparkRLibPath));
        }
        return sparkRLibPath;
    }
}

