/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.r;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.util.ProcessLauncher;
import org.apache.zeppelin.r.RInterpreter;
import org.apache.zeppelin.r.SparkRBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinR {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinR.class);
    private RInterpreter rInterpreter;
    private RProcessLogOutputStream processOutputStream;
    static Map<Integer, ZeppelinR> zeppelinR = Collections.synchronizedMap(new HashMap());
    private RProcessLauncher rProcessLauncher;
    private Request rRequestObject = null;
    private Integer rRequestNotifier = new Integer(0);
    private Object rResponseValue = null;
    private boolean rResponseError = false;
    private Integer rResponseNotifier = new Integer(0);

    public ZeppelinR(RInterpreter rInterpreter) {
        this.rInterpreter = rInterpreter;
    }

    public void open() throws IOException, InterpreterException {
        Object sparkRLibPath;
        String rCmdPath = this.rInterpreter.getProperty("zeppelin.R.cmd", "R");
        if (System.getenv("SPARK_HOME") != null) {
            sparkRLibPath = System.getenv("SPARK_HOME") + "/R/lib";
        } else if (System.getenv("ZEPPELIN_HOME") != null) {
            String interpreter = "r";
            if (this.rInterpreter.isSparkSupported()) {
                interpreter = "spark";
            }
            sparkRLibPath = System.getenv("ZEPPELIN_HOME") + "/interpreter/" + interpreter + "/R/lib";
            System.setProperty("spark.test.home", System.getenv("ZEPPELIN_HOME") + "/interpreter/" + interpreter);
        } else {
            sparkRLibPath = "sparkr";
        }
        if (!new File((String)sparkRLibPath).exists()) {
            throw new InterpreterException(String.format("sparkRLib %s doesn't exist", sparkRLibPath));
        }
        File scriptFile = File.createTempFile("zeppelin_sparkr-", ".R");
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(scriptFile);
            in = this.getClass().getClassLoader().getResourceAsStream("R/zeppelin_sparkr.R");
            IOUtils.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        zeppelinR.put(this.hashCode(), this);
        String timeout = this.rInterpreter.getProperty("spark.r.backendConnectionTimeout", "6000");
        CommandLine cmd = CommandLine.parse(rCmdPath);
        cmd.addArgument("--no-save");
        cmd.addArgument("--no-restore");
        cmd.addArgument("-f");
        cmd.addArgument(scriptFile.getAbsolutePath());
        cmd.addArgument("--args");
        cmd.addArgument(Integer.toString(this.hashCode()));
        cmd.addArgument(Integer.toString(SparkRBackend.get().port()));
        cmd.addArgument((String)sparkRLibPath);
        cmd.addArgument("" + this.rInterpreter.sparkVersion());
        cmd.addArgument(timeout);
        cmd.addArgument("" + this.rInterpreter.isSparkSupported());
        cmd.addArgument(SparkRBackend.get().socketSecret());
        LOGGER.info("R Command: {}", (Object)cmd);
        this.processOutputStream = new RProcessLogOutputStream(this.rInterpreter);
        Map<String, String> env = EnvironmentUtils.getProcEnvironment();
        this.rProcessLauncher = new RProcessLauncher(cmd, env, this.processOutputStream);
        this.rProcessLauncher.launch();
        this.rProcessLauncher.waitForReady(30000);
        if (!this.rProcessLauncher.isRunning()) {
            if (this.rProcessLauncher.isLaunchTimeout()) {
                throw new IOException("Launch r process is time out.\n" + this.rProcessLauncher.getErrorMessage());
            }
            throw new IOException("Fail to launch r process.\n" + this.rProcessLauncher.getErrorMessage());
        }
        this.eval("cat('')");
    }

    public void setInterpreterOutput(InterpreterOutput out) {
        this.processOutputStream.setInterpreterOutput(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String expr) throws InterpreterException {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("eval", expr, null);
            return this.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Object value) throws InterpreterException {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("set", key, value);
            this.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) throws InterpreterException {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("get", key, null);
            return this.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getS0(String key) throws InterpreterException {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("getS", key, null);
            return (String)this.request();
        }
    }

    private boolean isRProcessInitialized() {
        return this.rProcessLauncher != null && this.rProcessLauncher.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object request() throws RuntimeException {
        if (!this.isRProcessInitialized()) {
            throw new RuntimeException("r repl is not running");
        }
        this.rResponseValue = null;
        Integer n = this.rRequestNotifier;
        synchronized (n) {
            this.rRequestNotifier.notify();
        }
        Object respValue = null;
        Integer n2 = this.rResponseNotifier;
        synchronized (n2) {
            while (this.rResponseValue == null && this.isRProcessInitialized()) {
                try {
                    this.rResponseNotifier.wait(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
            respValue = this.rResponseValue;
            this.rResponseValue = null;
        }
        if (this.rResponseError) {
            throw new RuntimeException(respValue.toString());
        }
        return respValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request getRequest() {
        Integer n = this.rRequestNotifier;
        synchronized (n) {
            while (this.rRequestObject == null) {
                try {
                    this.rRequestNotifier.wait(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
            Request req = this.rRequestObject;
            this.rRequestObject = null;
            return req;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Object value, boolean error) {
        Integer n = this.rResponseNotifier;
        synchronized (n) {
            this.rResponseValue = value;
            this.rResponseError = error;
            this.rResponseNotifier.notify();
        }
    }

    public void onScriptInitialized() {
        this.rProcessLauncher.initialized();
    }

    public void close() {
        if (this.rProcessLauncher != null) {
            this.rProcessLauncher.stop();
        }
        zeppelinR.remove(this.hashCode());
    }

    public static ZeppelinR getZeppelinR(int hashcode) {
        return zeppelinR.get(hashcode);
    }

    public static class RProcessLogOutputStream
    extends ProcessLauncher.ProcessLogOutputStream {
        private InterpreterOutput interpreterOutput;
        private RInterpreter rInterpreter;

        public RProcessLogOutputStream(RInterpreter rInterpreter) {
            this.rInterpreter = rInterpreter;
        }

        public void setInterpreterOutput(InterpreterOutput interpreterOutput) {
            this.interpreterOutput = interpreterOutput;
        }

        protected void processLine(String s2, int i) {
            super.processLine(s2, i);
            if (s2.contains("Java SparkR backend might have failed") || s2.contains("Execution halted")) {
                this.rInterpreter.getRbackendDead().set(true);
            }
            if (this.interpreterOutput != null) {
                try {
                    this.interpreterOutput.write(s2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void close() throws IOException {
            super.close();
            if (this.interpreterOutput != null) {
                this.interpreterOutput.close();
            }
        }
    }

    class RProcessLauncher
    extends ProcessLauncher {
        public RProcessLauncher(CommandLine commandLine, Map<String, String> envs, ProcessLauncher.ProcessLogOutputStream processLogOutput) {
            super(commandLine, envs, processLogOutput);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForReady(int timeout) {
            long startTime = System.currentTimeMillis();
            RProcessLauncher rProcessLauncher = this;
            synchronized (rProcessLauncher) {
                while (this.state == ProcessLauncher.State.LAUNCHED) {
                    LOGGER.info("Waiting for R process initialized");
                    try {
                        ((Object)((Object)this)).wait(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (System.currentTimeMillis() - startTime <= (long)timeout) continue;
                    this.onTimeout();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialized() {
            RProcessLauncher rProcessLauncher = this;
            synchronized (rProcessLauncher) {
                this.state = ProcessLauncher.State.RUNNING;
                ((Object)((Object)this)).notify();
            }
        }
    }

    public static class Request {
        String type;
        String stmt;
        Object value;

        public Request(String type, String stmt, Object value) {
            this.type = type;
            this.stmt = stmt;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getStmt() {
            return this.stmt;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

