/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.util.Properties;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.r.IRInterpreter;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.apache.zeppelin.spark.SparkRInterpreter;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.spark.Utils;
import org.apache.zeppelin.spark.ZeppelinRContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkIRInterpreter
extends IRInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkRInterpreter.class);
    private SparkInterpreter sparkInterpreter;
    private SparkVersion sparkVersion;
    private SparkContext sc;
    private JavaSparkContext jsc;

    public SparkIRInterpreter(Properties properties) {
        super(properties);
    }

    @Override
    protected boolean isSparkSupported() {
        return true;
    }

    @Override
    protected int sparkVersion() {
        return this.sparkVersion.toNumber();
    }

    public void setSparkInterpreter(SparkInterpreter sparkInterpreter) {
        this.sparkInterpreter = sparkInterpreter;
    }

    @Override
    public void open() throws InterpreterException {
        if (this.sparkInterpreter == null) {
            this.sparkInterpreter = (SparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class));
        }
        this.sc = this.sparkInterpreter.getSparkContext();
        this.jsc = this.sparkInterpreter.getJavaSparkContext();
        this.sparkVersion = new SparkVersion(this.sc.version());
        ZeppelinRContext.setSparkContext(this.sc);
        ZeppelinRContext.setJavaSparkContext(this.jsc);
        ZeppelinRContext.setSparkSession(this.sparkInterpreter.getSparkSession());
        ZeppelinRContext.setSqlContext(this.sparkInterpreter.getSQLContext());
        ZeppelinRContext.setZeppelinContext(this.sparkInterpreter.getZeppelinContext());
        super.open();
    }

    @Override
    public InterpreterResult internalInterpret(String lines, InterpreterContext context) throws InterpreterException {
        Utils.printDeprecateMessage(this.sparkInterpreter.getSparkVersion(), context, this.properties);
        String jobGroup = Utils.buildJobGroupId(context);
        String jobDesc = Utils.buildJobDesc(context);
        this.sparkInterpreter.getSparkContext().setJobGroup(jobGroup, jobDesc, false);
        String setJobGroup = "dummy__ <- setJobGroup(\"" + jobGroup + "\", \" +" + jobDesc + "\", TRUE)";
        lines = setJobGroup + "\n" + (String)lines;
        Object setPoolStmt = "setLocalProperty('spark.scheduler.pool', NULL)";
        if (context.getLocalProperties().containsKey("pool")) {
            setPoolStmt = "setLocalProperty('spark.scheduler.pool', '" + (String)context.getLocalProperties().get("pool") + "')";
        }
        lines = (String)setPoolStmt + "\n" + (String)lines;
        return super.internalInterpret((String)lines, context);
    }
}

